// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author konstantin.aleev
 */
public interface LiveProperty<T> extends Disposable {
  void compute();

  @Nullable
  T getValue();

  /**
   * @return time stamp of the last computation or {@code -1} if property value has not been computed yet.
   */
  long getTimeStamp();

  void addPropertyListener(@NotNull LivePropertyListener listener);

  void removePropertyListener(@NotNull LivePropertyListener listener);

  interface LivePropertyListener {
    void propertyChanged();

    default void computationFailed(@NotNull Exception e) {
    }

    default void computationFinished() {
    }
  }
}
