// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.Disposable;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsModel;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * @author konstantin.aleev
 */
public interface SpringBootApplicationInfo extends Disposable {
  @NotNull
  RunProfile getRunProfile();

  @NotNull
  LiveProperty<Boolean> getReadyState();

  @NotNull
  LiveProperty<Integer> getServerPort();

  @NotNull
  LiveProperty<SpringBootApplicationServerConfiguration> getServerConfiguration();

  @NotNull
  LiveProperty<LiveBeansModel> getLiveBeansModel();

  @NotNull
  LiveProperty<Map> getHealth();

  @NotNull
  LiveProperty<LiveRequestMappingsModel> getRequestMappingsModel();

  @NotNull
  LiveProperty<String> getApplicationUrl();
}
