// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run.lifecycle.beans;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author konstantin.aleev
 */
public interface LiveContext {
  @NotNull
  String getName();

  @Nullable
  LiveContext getParent();

  @NotNull
  List<LiveResource> getResources();

  @NotNull
  List<LiveBean> getBeans();
}
