// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run.lifecycle.beans;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;
import java.util.List;

/**
 * @author konstantin.aleev
 */
public interface LiveResource {
  @NotNull
  String getDescription();

  @NotNull
  LiveContext getContext();

  @NotNull
  List<LiveBean> getBeans();

  /**
   * @return {@code true} if resource description is not empty and does not equal to {@code "null"}, {@code false} otherwise.
   */
  boolean hasDescription();

  /**
   * @return live resource display name
   */
  @NotNull
  String getDisplayName();

  /**
   * Must be invoked when read access is allowed.
   */
  @Nullable
  Navigatable getResourceNavigatable(@NotNull Project project,
                                     @Nullable Module module,
                                     @Nullable PsiElement runConfigurationElement,
                                     @NotNull GlobalSearchScope searchScope);

  /**
   * Returns the result of invocation of {@link #getResourceNavigatable(Project, Module, PsiElement, GlobalSearchScope)}
   * if result could be cast to {@link PsiElement}, {@code null} otherwise.
   *
   * @see #getResourceNavigatable(Project, Module, PsiElement, GlobalSearchScope)
   */
  @Nullable
  PsiElement getResourceElement(@NotNull Project project,
                                @Nullable Module module,
                                @Nullable PsiElement runConfigurationElement,
                                @NotNull GlobalSearchScope searchScope);

  /**
   * @return the substring of resource description between square brackets which contains a path to the resource or
   * the resource description if it does not contain square brackets.
   */
  @NotNull
  String getResourcePath();

  @Nullable
  Icon getIcon();
}
