// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run.lifecycle.mappings;

import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author konstantin.aleev
 */
public interface LiveRequestMappingsModel {
  /**
   * @return all request mappings
   */
  @NotNull
  List<LiveRequestMapping> getRequestMappings();

  /**
   * @param psiMethod method to match
   * @return the list of request mappings which match the given method
   */
  @NotNull
  List<LiveRequestMapping> getRequestMappingsByMethod(@NotNull PsiMethod psiMethod);
}
