/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramFileType;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.uml.utils.UmlBundle;
import com.intellij.uml.utils.VcsUtils;
import com.intellij.util.containers.FixedHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    @NonNls
    public static final String PROTOCOL = "uml";
    @NonNls
    public static final String PROTOCOL_PREFIX = "uml://";
    @NonNls
    public static final String CHANGES = "uml://$SHOW_CHANGES$/";
    private final Map<String, VirtualFile> cache = new FixedHashMap(30);

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlVirtualFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/uml/UmlVirtualFileSystem", "findFileByPath"));
        }
        VirtualFile file = this.cache.get(path);
        if (file == null) {
            file = new UmlVirtualFile(path);
            this.cache.put(path, file);
        }
        return file;
    }

    public void refresh(boolean asynchronous) {
    }

    public static boolean isInitialized(VirtualFile vf) {
        return vf instanceof UmlVirtualFile && ((UmlVirtualFile)vf).isInitialized();
    }

    public static void setInitialized(VirtualFile vf) {
        if (vf instanceof UmlVirtualFile) {
            ((UmlVirtualFile)vf).setInitialized(true);
        }
    }

    public static String getFileUrlByChangeList(@NotNull LocalChangeList changeList) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/uml/UmlVirtualFileSystem", "getFileUrlByChangeList"));
        }
        return CHANGES + changeList.getId() + "/" + changeList.getName();
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/uml/UmlVirtualFileSystem", "refreshAndFindFileByPath"));
        }
        return this.findFileByPath(path);
    }

    public static boolean isUmlVirtualFile(VirtualFile file) {
        return file instanceof UmlVirtualFile;
    }

    @Presentation(icon="AllIcons.FileTypes.Diagram")
    public class UmlVirtualFile
    extends VirtualFile
    implements VirtualFilePathWrapper,
    Disposable {
        private final String myName;
        private boolean initialized;
        private String myPresentableName;
        private Project myProject;
        private long myTimestamp;
        private long myModificationStamp;
        private final byte[] data;
        private DiagramState myState;
        private final List<DiagramBuilder> myBuilders;

        public UmlVirtualFile(String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/uml/UmlVirtualFileSystem$UmlVirtualFile", "<init>"));
            }
            this.initialized = false;
            this.myTimestamp = 0L;
            this.myModificationStamp = 0L;
            this.data = new byte[0];
            this.myState = null;
            this.myBuilders = new ArrayList<DiagramBuilder>();
            this.myName = name;
            this.updateTimeStamp();
        }

        private void updateTimeStamp() {
            this.myTimestamp = System.currentTimeMillis();
            ++this.myModificationStamp;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlVirtualFileSystem$UmlVirtualFile", "getName"));
            }
            return string;
        }

        @Nullable
        public DiagramProvider getUmlProvider() {
            int ind = this.myName.indexOf(47);
            if (ind == -1) {
                return null;
            }
            return DiagramProvider.findByID((String)this.myName.substring(0, ind));
        }

        @Nullable
        public String getFQN() {
            int ind = this.myName.indexOf(47);
            if (ind == -1) {
                return null;
            }
            return this.myName.substring(ind + 1);
        }

        public String getShortName() {
            if (this.myPresentableName != null) {
                return this.myPresentableName;
            }
            int ind = this.myName.lastIndexOf(46);
            return ind < 0 ? this.myName : this.myName.substring(++ind);
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            UmlVirtualFileSystem umlVirtualFileSystem = UmlVirtualFileSystem.this;
            if (umlVirtualFileSystem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlVirtualFileSystem$UmlVirtualFile", "getFileSystem"));
            }
            return umlVirtualFileSystem;
        }

        @NotNull
        public String getPath() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlVirtualFileSystem$UmlVirtualFile", "getPath"));
            }
            return string;
        }

        public boolean isWritable() {
            return true;
        }

        public boolean isDirectory() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public DiagramState getState() {
            return this.myState;
        }

        public void setState(DiagramState state) {
            this.myState = state;
        }

        @Nullable
        public VirtualFile getParent() {
            return null;
        }

        public VirtualFile[] getChildren() {
            return EMPTY_ARRAY;
        }

        @NotNull
        public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
            throw new UnsupportedOperationException("getOutputStream is not implemented in : " + ((Object)((Object)this)).getClass());
        }

        @NotNull
        public byte[] contentsToByteArray() throws IOException {
            throw new UnsupportedOperationException("contentsToByteArray is not implemented in : " + ((Object)((Object)this)).getClass());
        }

        public long getTimeStamp() {
            return this.myTimestamp;
        }

        public long getLength() {
            return this.data.length;
        }

        public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException("getInputStream is not implemented in : " + ((Object)((Object)this)).getClass());
        }

        public long getModificationStamp() {
            return this.myModificationStamp;
        }

        public String getPresentableName() {
            if (this.getUmlProvider() == null) {
                return VcsUtils.isShowChangesFile(this) ? UmlBundle.message("uml.file.name.for.changes", this.getChangeListName()) : UmlBundle.message("uml.class.diagramm.file.name", this.getShortName());
            }
            return VcsUtils.isShowChangesFile(this) ? UmlBundle.message("uml.file.name.for.changes", this.getChangeListName()) : this.getShortName();
        }

        private String getChangeListName() {
            return this.getPath().substring(UmlVirtualFileSystem.CHANGES.length()).split("/")[1];
        }

        public boolean equals(Object obj) {
            return obj instanceof UmlVirtualFile && this.myName.equals(((UmlVirtualFile)((Object)obj)).getName());
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        @NotNull
        public FileType getFileType() {
            DiagramFileType diagramFileType = DiagramFileType.INSTANCE;
            if (diagramFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlVirtualFileSystem$UmlVirtualFile", "getFileType"));
            }
            return diagramFileType;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public void setInitialized(boolean initialized) {
            this.initialized = initialized;
        }

        public void setPresentableName(String presentableName) {
            this.myPresentableName = presentableName;
        }

        @NotNull
        public String getPresentablePath() {
            String string = this.getPresentableName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlVirtualFileSystem$UmlVirtualFile", "getPresentablePath"));
            }
            return string;
        }

        public boolean enforcePresentableName() {
            return true;
        }

        public Project getProject() {
            return this.myProject;
        }

        public void setProject(Project project) {
            this.myProject = project;
            Disposer.register((Disposable)this.myProject, (Disposable)this);
        }

        @Nullable
        public DiagramBuilder getBuilder() {
            return this.myBuilders.isEmpty() ? null : this.myBuilders.get(this.myBuilders.size() - 1);
        }

        public void addBuilder(final DiagramBuilder builder) {
            if (!this.myBuilders.contains(builder)) {
                this.myBuilders.add(builder);
            }
            Disposer.register((Disposable)builder, (Disposable)new Disposable(){

                public void dispose() {
                    UmlVirtualFile.this.myBuilders.remove(builder);
                    if (UmlVirtualFile.this.myBuilders.isEmpty()) {
                        Disposer.dispose((Disposable)UmlVirtualFile.this);
                    }
                }
            });
        }

        public void dispose() {
            this.myProject = null;
            this.myState = null;
            this.myBuilders.clear();
            this.initialized = false;
        }

        @Nullable
        public DiagramDataModel getDataModel() {
            return this.myBuilders.isEmpty() ? null : this.myBuilders.get(0).getDataModel();
        }

        @Nullable
        public DiagramPresentationModel getPresentationModel() {
            return this.myBuilders.isEmpty() ? null : this.myBuilders.get(0).getPresentationModel();
        }
    }
}

