/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;

public class MSFileInputStream
extends FilterInputStream {
    private File file = null;
    protected int readlimit = -1;
    protected int count = 0;
    protected int markpos = 0;

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int n) {
        this.readlimit = n;
        this.markpos = this.count;
    }

    public synchronized void reset() throws IOException {
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        if (this.count - this.markpos > this.readlimit) {
            throw new IOException("Read limit reached, invalid mark");
        }
        this.in.close();
        this.in = new FileInputStream(this.file);
        if (this.markpos > 0) {
            this.in.skip(this.markpos);
        }
        this.markpos = 0;
        this.count = 0;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            ++this.count;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray, 0, byArray.length);
        if (n != -1) {
            this.count += n;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 != -1) {
            this.count += n3;
        }
        return n3;
    }

    public MSFileInputStream(File file) throws FileNotFoundException {
        super(new FileInputStream(file));
        this.file = file;
    }

    public MSFileInputStream(String string) throws FileNotFoundException {
        super(new FileInputStream(string));
        this.file = new File(string);
    }
}

