/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.icp;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilter;
import org.w3c.www.protocol.http.PropRequestFilterException;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.icp.ICPQuery;
import org.w3c.www.protocol.http.icp.ICPReceiver;
import org.w3c.www.protocol.http.icp.ICPReply;
import org.w3c.www.protocol.http.icp.ICPSender;
import org.w3c.www.protocol.http.icp.ICPWaiter;

public class ICPFilter
implements PropRequestFilter,
PropertyMonitoring {
    public static final String DEBUG_P = "org.w3c.www.protocol.http.icp.debug";
    public static final String CONFIG_P = "org.w3c.www.protocol.http.icp.config";
    public static final String PORT_P = "org.w3c.www.protocol.http.icp.port";
    public static final String TIMEOUT_P = "org.w3c.www.protocol.http.icp.timeout";
    public static final String DISABLE_CACHE_P = "org.w3c.www.protocol.http.icp.disable-cache";
    protected ObservableProperties props = null;
    protected ICPReceiver icp = null;
    ICPSender[] senders = null;
    protected Hashtable friends = null;
    protected long timeoutValue = 500L;
    protected boolean debug = false;
    int port = -1;
    protected boolean disableCache = true;

    public boolean propertyChanged(String string) {
        System.out.println("ICPFilter:" + string + ": property changed.");
        return true;
    }

    protected DatagramSocket getSocket() {
        return this.icp.getSocket();
    }

    protected void createICPSender(String string, int n, String string2) throws UnknownHostException, MalformedURLException, SocketException {
        Object[] objectArray;
        InetAddress inetAddress = InetAddress.getByName(string);
        URL uRL = new URL(string2);
        ICPSender iCPSender = new ICPSender(this, this.port, inetAddress, n, uRL);
        if (this.senders == null) {
            this.senders = new ICPSender[1];
            this.senders[0] = iCPSender;
        } else {
            objectArray = new ICPSender[this.senders.length + 1];
            System.arraycopy(this.senders, 0, objectArray, 0, this.senders.length);
            objectArray[this.senders.length] = iCPSender;
            this.senders = objectArray;
        }
        objectArray = inetAddress.getAddress();
        Long l = new Long(((long)n << 32) + (long)((objectArray[0] & 0xFF) << 24) + (long)((objectArray[1] & 0xFF) << 16) + (long)((objectArray[2] & 0xFF) << 8) + (long)(objectArray[3] & 0xFF));
        this.friends.put(l, iCPSender);
        if (this.debug) {
            System.out.println("icp: friend " + l + " http=" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseConfiguration() {
        DataInputStream dataInputStream = null;
        String string = null;
        int n = -1;
        String string2 = null;
        File file = this.props.getFile(CONFIG_P, new File("icp.conf"));
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException iOException) {
            System.out.println("*** ICP, unable to read config file " + file.getAbsolutePath());
            return;
        }
        try {
            String string3 = null;
            while ((string3 = dataInputStream.readLine()) != null) {
                if (string3.startsWith("#") || string3.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, " \t");
                string = stringTokenizer.nextToken();
                n = Integer.parseInt(stringTokenizer.nextToken());
                string2 = stringTokenizer.nextToken();
                this.createICPSender(string, n, string2);
            }
        }
        catch (Exception exception) {
            System.out.println("*** ICP, unable to create " + string + "@" + n + "[" + string2 + "]: " + exception.getMessage());
        }
        finally {
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public ICPSender getSender(InetAddress inetAddress, int n) {
        byte[] byArray = inetAddress.getAddress();
        Long l = new Long(((long)n << 32) + (long)((byArray[0] & 0xFF) << 24) + (long)((byArray[1] & 0xFF) << 16) + (long)((byArray[2] & 0xFF) << 8) + (long)(byArray[3] & 0xFF));
        return (ICPSender)this.friends.get(l);
    }

    protected URL locateProxy(ICPReply iCPReply) {
        ICPSender iCPSender = this.getSender(iCPReply.getSenderAddress(), iCPReply.getSenderPort());
        return iCPSender != null ? iCPSender.getProxyLocation() : null;
    }

    protected int sendQuery(ICPQuery iCPQuery) {
        int n = 0;
        if (this.senders != null) {
            for (int i = 0; i < this.senders.length; ++i) {
                if (this.debug) {
                    System.out.println("icp: query@" + this.senders[i].getAddress() + "/" + this.senders[i].getPort() + " for " + iCPQuery.getURL());
                }
                if (!this.senders[i].send(iCPQuery)) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL runQuery(ICPQuery iCPQuery) {
        ICPWaiter iCPWaiter = new ICPWaiter(iCPQuery.getIdentifier());
        this.icp.addReplyWaiter(iCPWaiter);
        try {
            long l = -1L;
            long l2 = -1L;
            long l3 = this.timeoutValue;
            for (int i = this.sendQuery(iCPQuery); i > 0 && l3 > 0L; --i, l3 -= l2 - l) {
                ICPReply iCPReply = iCPWaiter.getNextReply(l3);
                if (iCPReply != null) {
                    if (iCPReply.isHit()) {
                        URL uRL = this.locateProxy(iCPReply);
                        return uRL;
                    }
                } else {
                    URL uRL = null;
                    return uRL;
                }
                l2 = System.currentTimeMillis();
                l = l2;
            }
        }
        finally {
            this.icp.removeReplyWaiter(iCPWaiter);
        }
        return null;
    }

    public boolean exceptionFilter(Request request, HttpException httpException) {
        return false;
    }

    public Reply ingoingFilter(Request request) {
        ICPQuery iCPQuery;
        URL uRL;
        if (request.getMethod().equals("GET") && !request.hasState("org.w3c.www.protocol.http.cache.dont") && !request.hasState("org.w3c.www.protocol.http.cache.revalidation") && (uRL = this.runQuery(iCPQuery = this.icp.createQuery(request.getURL()))) != null) {
            if (this.debug) {
                System.out.println("*** routing " + request.getURL() + " to " + uRL);
            }
            if (this.disableCache) {
                request.setState("org.w3c.www.protocol.http.cache.dont", Boolean.TRUE);
            }
            request.setProxy(uRL);
        }
        return null;
    }

    public Reply outgoingFilter(Request request, Reply reply) {
        return null;
    }

    public void sync() {
    }

    public void initialize(HttpManager httpManager) throws PropRequestFilterException {
        this.props = httpManager.getProperties();
        this.props.registerObserver(this);
        this.port = this.props.getInteger(PORT_P, 2005);
        this.friends = new Hashtable(10);
        this.debug = this.props.getBoolean(DEBUG_P, false);
        if (this.debug) {
            System.out.println("[" + this.getClass().getName() + "]: debugging on");
        }
        this.parseConfiguration();
        this.timeoutValue = this.props.getInteger(TIMEOUT_P, (int)this.timeoutValue);
        this.disableCache = this.props.getBoolean(DISABLE_CACHE_P, this.disableCache);
        try {
            this.icp = new ICPReceiver(httpManager, this, this.port);
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            throw new PropRequestFilterException(socketException.getMessage());
        }
        if (this.debug) {
            System.out.println("icp: listening on port " + this.port);
        }
        httpManager.setFilter(this);
    }
}

