/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfigurationProducerKt;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.JavaScriptDebugEngine;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/debugger/execution/JavaScriptDebugConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lcom/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration;", "", "()V", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "JavaScriptDebugger"})
public final class JavaScriptDebugConfigurationProducer
extends RunConfigurationProducer<JavaScriptDebugConfiguration>
implements Cloneable {
    protected boolean setupConfigurationFromContext(@NotNull JavaScriptDebugConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        Url url = WebBrowserServiceImpl.getDebuggableUrl((PsiElement)((PsiElement)sourceElement.get()));
        if (url == null) {
            return false;
        }
        Url url2 = url;
        PsiFile file = ((PsiElement)sourceElement.get()).getContainingFile();
        configuration.setUri(url2.toDecodedForm());
        configuration.setGeneratedName();
        PsiFile psiFile = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
        WebBrowser webBrowser = JavaScriptDebugEngine.Companion.getPreferredBrowser(psiFile);
        if (webBrowser != null) {
            WebBrowser webBrowser2 = webBrowser;
            WebBrowser it = webBrowser2;
            configuration.setEngineId(it.getId().toString());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        sourceElement.set((Object)file);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull JavaScriptDebugConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return JavaScriptDebugConfigurationProducerKt.isConfigurationFromContext(configuration, context.getPsiLocation());
    }

    public JavaScriptDebugConfigurationProducer() {
        super(JavascriptDebugConfigurationType.getTypeInstance().getFactory());
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }
}

