/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.browserConnection;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.AboutHttpService;

public final class IdeService {
    private static final Condition<Project> NULLIZE_PROJECT_CONDITION = project -> project == null || !project.isInitialized() || project.isDefault();

    private IdeService() {
    }

    public static void focusProjectWindow(@NotNull String pageUrl) {
        if (pageUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pageUrl", "com/jetbrains/browserConnection/IdeService", "focusProjectWindow"));
        }
        IdeService.doFocus(IdeService.findProject(Urls.newFromEncoded((String)pageUrl)));
    }

    public static ByteBuf about() throws IOException {
        ByteBuf buffer = ByteBufAllocator.DEFAULT.ioBuffer();
        boolean success = false;
        try {
            AboutHttpService.getAbout((OutputStream)new ByteBufOutputStream(buffer), null);
            success = true;
        }
        finally {
            if (!success) {
                buffer.release();
            }
        }
        return buffer;
    }

    @Nullable
    public static Project findProject(@NotNull Url url) {
        Project lastProject;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/browserConnection/IdeService", "findProject"));
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length == 1) {
            return (Project)ObjectUtils.nullizeByCondition((Object)projects[0], NULLIZE_PROJECT_CONDITION);
        }
        if (projects.length == 0) {
            return null;
        }
        IdeFrame lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project project = lastProject = lastFocusedFrame == null ? null : (Project)ObjectUtils.nullizeByCondition((Object)lastFocusedFrame.getProject(), NULLIZE_PROJECT_CONDITION);
        if (lastProject != null && IdeService.findFile(url, lastProject) != null) {
            return lastProject;
        }
        for (Project project2 : projects) {
            if (NULLIZE_PROJECT_CONDITION.value((Object)project2) || project2 == lastProject || IdeService.findFile(url, project2) == null) continue;
            return project2;
        }
        return (Project)ObjectUtils.nullizeByCondition((Object)projects[projects.length - 1], NULLIZE_PROJECT_CONDITION);
    }

    @Nullable
    private static Project findFile(@NotNull Url url, @NotNull Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/browserConnection/IdeService", "findFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/browserConnection/IdeService", "findFile"));
        }
        for (FileUrlMapper mapper : (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions()) {
            if (mapper.getFile(url, project, null) == null) continue;
            return project;
        }
        return null;
    }

    private static void doFocus(@Nullable Project project) {
        if (project == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> ProjectUtil.focusProjectWindow((Project)project, (boolean)true), project.getDisposed());
    }
}

