/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.javascript.debugger.JsFileUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010 \u001a\u00020\bH\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nRB\u0010\u000b\u001a*\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u0001 \u000e*\u0014\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f8BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/javascript/debugger/DebuggableFileFinderImpl;", "Lcom/intellij/javascript/debugger/impl/DebuggableFileFinder;", "project", "Lcom/intellij/openapi/project/Project;", "requestor", "Lcom/intellij/util/Url;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/util/Url;)V", "authority", "", "getAuthority$JavaScriptDebugger", "()Ljava/lang/String;", "fileUrlMappers", "", "Lcom/jetbrains/javascript/debugger/FileUrlMapper;", "kotlin.jvm.PlatformType", "getFileUrlMappers", "()[Lcom/jetbrains/javascript/debugger/FileUrlMapper;", "fileUrlMappers$delegate", "Lkotlin/Lazy;", "scheme", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "findFileByAuthority", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "findRemoteUrlByExtensionMappers", "", "file", "getRemoteUrls", "isDebuggable", "", "toString", "JavaScriptDebugger"})
public final class DebuggableFileFinderImpl
extends DebuggableFileFinder {
    private final String scheme;
    @Nullable
    private final String authority;
    private final Lazy fileUrlMappers$delegate;
    private final Project project;
    private final Url requestor;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @Nullable
    public final String getAuthority$JavaScriptDebugger() {
        return this.authority;
    }

    private final FileUrlMapper[] getFileUrlMappers() {
        Lazy lazy = this.fileUrlMappers$delegate;
        DebuggableFileFinderImpl debuggableFileFinderImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (FileUrlMapper[])lazy.getValue();
    }

    public final boolean isDebuggable(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.authority == null || WebServerPathToFileManager.Companion.getInstance(project).getPath(file) != null || !this.findRemoteUrlByExtensionMappers(file).isEmpty();
    }

    private final List<Url> findRemoteUrlByExtensionMappers(VirtualFile file) {
        List list;
        List result = null;
        if (this.getFileUrlMappers() != null) {
            FileUrlMapper[] fileUrlMapperArray = this.getFileUrlMappers();
            if (fileUrlMapperArray == null) {
                Intrinsics.throwNpe();
            }
            FileUrlMapper[] fileUrlMapperArray2 = fileUrlMapperArray;
            for (int i = 0; i < fileUrlMapperArray2.length; ++i) {
                FileUrlMapper mapper = fileUrlMapperArray2[i];
                List urls = mapper.getUrls(file, this.project, this.authority);
                if (urls.isEmpty()) continue;
                if (result == null) {
                    result = (List)new SmartList();
                }
                Collection collection = urls;
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"urls");
                result.addAll(collection);
            }
        }
        if ((list = result) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Navigatable navigatable;
        block7: {
            block6: {
                Navigatable navigatable2;
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    if (url.isInLocalFileSystem()) {
                        return (Navigatable)JsFileUtil.createNavigatable(project, LocalFileFinder.findFile((String)url.getPath()));
                    }
                    navigatable = this.getFileUrlMappers();
                    if (navigatable == null) break block6;
                    Object[] $receiver$iv = (Object[])navigatable;
                    for (int i = 0; i < $receiver$iv.length; ++i) {
                        Object file$iv = $receiver$iv[i];
                        FileUrlMapper it = (FileUrlMapper)file$iv;
                        Navigatable result$iv = it.getNavigatable(url, project, this.requestor);
                        if (result$iv == null) continue;
                        navigatable2 = result$iv;
                        break block5;
                    }
                    navigatable2 = null;
                }
                if ((navigatable = (Navigatable)navigatable2) != null) break block7;
            }
            navigatable = (Navigatable)JsFileUtil.createNavigatable(project, this.findFileByAuthority(url, project));
        }
        return navigatable;
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        VirtualFile virtualFile;
        block9: {
            block8: {
                VirtualFile virtualFile2;
                block7: {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    if (url.isInLocalFileSystem()) {
                        String path = url.getPath();
                        if (LocalFileFinder.windowsDriveExists((String)path)) {
                            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                            VirtualFile virtualFile3 = localFileSystem.findFileByPath(path);
                            if (virtualFile3 == null) {
                                virtualFile3 = localFileSystem.refreshAndFindFileByPath(path);
                            }
                            return virtualFile3;
                        }
                        return null;
                    }
                    virtualFile = this.getFileUrlMappers();
                    if (virtualFile == null) break block8;
                    Object[] $receiver$iv = (Object[])virtualFile;
                    for (int i = 0; i < $receiver$iv.length; ++i) {
                        Object file$iv = $receiver$iv[i];
                        FileUrlMapper it = (FileUrlMapper)file$iv;
                        VirtualFile result$iv = it.getFile(url, project, this.requestor);
                        if (result$iv == null) continue;
                        virtualFile2 = result$iv;
                        break block7;
                    }
                    virtualFile2 = null;
                }
                if ((virtualFile = (VirtualFile)virtualFile2) != null) break block9;
            }
            virtualFile = this.findFileByAuthority(url, project);
        }
        return virtualFile;
    }

    private final VirtualFile findFileByAuthority(Url url, Project project) {
        if (this.authority != null && StringsKt.equals((String)this.authority, (String)url.getAuthority(), (boolean)true)) {
            WebServerPathToFileManager webServerPathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
            String string = url.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.path");
            return WebServerPathToFileManager.findVirtualFile$default((WebServerPathToFileManager)webServerPathToFileManager, (String)string, (boolean)false, (int)2, null);
        }
        return null;
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        List<Url> urls = this.findRemoteUrlByExtensionMappers(file);
        if (!urls.isEmpty()) {
            return urls;
        }
        if (this.authority != null) {
            String string = WebServerPathToFileManager.Companion.getInstance(this.project).getPath(file);
            if (string != null) {
                String string2 = string;
                String it = string2;
                String string3 = this.scheme;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                char c = '/';
                String string4 = this.authority;
                String string5 = string3;
                String string6 = String.valueOf(c) + it;
                return CollectionsKt.listOf((Object)Urls.newUrl((String)string5, (String)string4, (String)string6));
            }
        }
        return CollectionsKt.listOf((Object)Urls.newFromVirtualFile((VirtualFile)file));
    }

    @NotNull
    public String toString() {
        return "DefaultFileFinder";
    }

    public DebuggableFileFinderImpl(@NotNull Project project, @Nullable Url requestor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.requestor = requestor;
        this.fileUrlMappers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FileUrlMapper[]>(this){
            final /* synthetic */ DebuggableFileFinderImpl this$0;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final FileUrlMapper[] invoke() {
                Object object;
                if (DebuggableFileFinderImpl.access$getRequestor$p(this.this$0) != null && DebuggableFileFinderImpl.access$getRequestor$p(this.this$0).isInLocalFileSystem()) {
                    object = null;
                } else {
                    void var1_1;
                    FileUrlMapper[] extensions = (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions();
                    Object[] objectArray = extensions;
                    object = objectArray.length == 0 ? (FileUrlMapper[])null : var1_1;
                }
                return object;
            }
            {
                this.this$0 = debuggableFileFinderImpl;
                super(0);
            }
        }));
        if (this.requestor != null && this.requestor.isInLocalFileSystem()) {
            this.authority = null;
            this.scheme = null;
        } else if (this.requestor == null) {
            this.authority = null;
            this.scheme = null;
        } else {
            this.authority = this.requestor.getAuthority();
            this.scheme = this.requestor.getScheme();
        }
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DebuggableFileFinderImpl.class), "fileUrlMappers", "getFileUrlMappers()[Lcom/jetbrains/javascript/debugger/FileUrlMapper;"))};
    }

    @Nullable
    public static final /* synthetic */ Url access$getRequestor$p(DebuggableFileFinderImpl $this) {
        return $this.requestor;
    }
}

