/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.javascript.debugger.FilePathRegExpCreator;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcessKt;
import com.jetbrains.javascript.debugger.JavaScriptLineBreakpointManager;
import com.jetbrains.javascript.debugger.JavaScriptLineBreakpointManagerKt;
import com.jetbrains.javascript.debugger.PsiVisitorKt;
import com.jetbrains.javascript.debugger.SourceMapHelperKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.LineBreakpointManager;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptRegExpBreakpointTarget;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\"\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0003J.\u0010\u001d\u001a\u00020\u00162\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0013H\u0014J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0 2\u0006\u0010!\u001a\u00020\"H\u0014J\u001e\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0 J\u0018\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0 2\u0006\u0010&\u001a\u00020\u000eJ\"\u0010'\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020(H\u0002J$\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0 2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\u0006\u0010,\u001a\u00020\u001cJ\u0010\u0010-\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u001c2\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u001cJ\u0016\u00103\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u001cJF\u00104\u001a\u001e\u0012\u001a\u0012\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180 050 2\u0006\u00100\u001a\u00020\u00072\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u00010;J\u001a\u0010<\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u00100\u001a\u00020\u0007RC\u0010\u0005\u001a7\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012 \u0012\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n \b*\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0018\u00010\t0\t0\u0006\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/jetbrains/javascript/debugger/JavaScriptLineBreakpointManager;", "Lorg/jetbrains/debugger/LineBreakpointManager;", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;)V", "actualLocationNotFound", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/debugger/Vm;", "kotlin.jvm.PlatformType", "", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lorg/jetbrains/annotations/NotNull;", "anyFirstLineBreakpoints", "Lcom/intellij/util/containers/ConcurrentList;", "Lorg/jetbrains/debugger/Breakpoint;", "beforeBreakpointRemoved", "", "breakpoint", "disable", "", "checkDuplicates", "newTarget", "Lorg/jetbrains/debugger/BreakpointTarget;", "location", "Lorg/jetbrains/debugger/Location;", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "createNameRegExp", "", "createTarget", "isTemporary", "doRunToLocation", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "findBreakpoints", "", "breakpointsHit", "vmBreakpoint", "findExisting", "Lorg/jetbrains/debugger/ScriptRegExpBreakpointTarget;", "findTopFirstLineBreakpoints", "context", "Lorg/jetbrains/debugger/SuspendContext;", "scriptName", "isAnyFirstLineBreakpoint", "isUseScriptIdTarget", "setAnyFirstLineBreakpoint", "vm", "regExp", "condition", "setMeteorAnyClientScriptBreakpointIfNeed", "sourceMapFound", "Lkotlin/Pair;", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "script", "Lorg/jetbrains/debugger/Script;", "scriptUrl", "Lcom/intellij/util/Url;", "sourceMapNotFound", "JavaScriptDebugger"})
public final class JavaScriptLineBreakpointManager
extends LineBreakpointManager {
    private final ConcurrentList<Breakpoint> anyFirstLineBreakpoints;
    private final ConcurrentMap<Vm, Set<XLineBreakpoint<?>>> actualLocationNotFound;
    private final JavaScriptDebugProcess<?> debugProcess;

    public boolean isAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        return this.anyFirstLineBreakpoints.contains((Object)breakpoint);
    }

    public final void setAnyFirstLineBreakpoint(@NotNull Vm vm, @NotNull String regExp, @Nullable String condition) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)regExp, (String)"regExp");
        BreakpointManager breakpointManager = vm.getBreakpointManager();
        JavaScriptDebugProcessKt.getLOG().assertTrue(breakpointManager.getRegExpBreakpointSupported());
        this.anyFirstLineBreakpoints.add((Object)BreakpointManager.DefaultImpls.setBreakpoint$default((BreakpointManager)breakpointManager, (BreakpointTarget)((BreakpointTarget)new ScriptRegExpBreakpointTarget(regExp, null, 2, null)), (int)0, (int)0, null, (String)condition, (int)0, (boolean)false, null, (int)236, null));
    }

    public static /* bridge */ /* synthetic */ void setAnyFirstLineBreakpoint$default(JavaScriptLineBreakpointManager javaScriptLineBreakpointManager, Vm vm, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setAnyFirstLineBreakpoint");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        javaScriptLineBreakpointManager.setAnyFirstLineBreakpoint(vm, string, string2);
    }

    public final void setMeteorAnyClientScriptBreakpointIfNeed(@NotNull Vm vm, @NotNull String regExp) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)regExp, (String)"regExp");
        for (Breakpoint breakpoint : this.anyFirstLineBreakpoints) {
            BreakpointTarget breakpointTarget = breakpoint.getTarget();
            if (breakpointTarget == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.ScriptRegExpBreakpointTarget");
            }
            if (!Intrinsics.areEqual((Object)((ScriptRegExpBreakpointTarget)breakpointTarget).toString(), (Object)regExp)) continue;
            return;
        }
        JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default(this, vm, regExp, null, 4, null);
    }

    protected void beforeBreakpointRemoved(@NotNull XLineBreakpoint<?> breakpoint, boolean disable) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        if (!disable) {
            Iterator iterator;
            Map map = this.actualLocationNotFound;
            Iterator iterator2 = iterator = map.entrySet().iterator();
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Map.Entry entry = iterator3.next();
                if (!((Set)entry.getValue()).remove(breakpoint) || !((Set)entry.getValue()).isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    private final boolean isUseScriptIdTarget(Location location) {
        if (this.debugProcess.isFilesOnlyInLocalFileSystem()) {
            return true;
        }
        if (!this.anyFirstLineBreakpoints.isEmpty()) {
            String scriptUrl = location.getUrl().toExternalForm();
            for (Breakpoint breakpoint : this.anyFirstLineBreakpoints) {
                if (!(breakpoint.getTarget() instanceof ScriptRegExpBreakpointTarget)) continue;
                String string = breakpoint.getTarget().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"breakpoint.target.toString()");
                String string2 = scriptUrl;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"scriptUrl");
                if (!JavaScriptLineBreakpointManagerKt.match(string, string2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected BreakpointTarget createTarget(@Nullable XLineBreakpoint<?> breakpoint, @NotNull BreakpointManager breakpointManager, @NotNull Location location, boolean isTemporary) {
        Script script;
        block5: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)breakpointManager, (String)"breakpointManager");
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                script = location.getScript();
                if (isTemporary) break block5;
                if (script != null && this.isUseScriptIdTarget(location)) {
                    return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
                }
                if (!breakpointManager.getRegExpBreakpointSupported()) break block5;
                if (location.getUrl().isInLocalFileSystem()) break block6;
                CharSequence charSequence = location.getUrl().getAuthority();
                if (charSequence == null || charSequence.length() == 0) break block5;
            }
            return (BreakpointTarget)new ScriptRegExpBreakpointTarget(this.createNameRegExp(location), this.debugProcess.getBreakpointLanguageHint(breakpoint, location));
        }
        if (script == null) {
            return (BreakpointTarget)new BreakpointTarget.ScriptName(location.getUrl().toExternalForm());
        }
        return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
    }

    @Nullable
    protected Breakpoint checkDuplicates(@NotNull BreakpointTarget newTarget, @NotNull Location location, @NotNull BreakpointManager breakpointManager) {
        Intrinsics.checkParameterIsNotNull((Object)newTarget, (String)"newTarget");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)breakpointManager, (String)"breakpointManager");
        if (location.getScript() != null && newTarget instanceof ScriptRegExpBreakpointTarget) {
            Breakpoint breakpoint = this.findExisting(breakpointManager, location, (ScriptRegExpBreakpointTarget)newTarget);
            if (breakpoint != null) {
                Breakpoint breakpoint2 = breakpoint;
                Breakpoint it = breakpoint2;
                return it;
            }
        }
        return super.checkDuplicates(newTarget, location, breakpointManager);
    }

    private final Breakpoint findExisting(BreakpointManager breakpointManager, Location location, ScriptRegExpBreakpointTarget newTarget) {
        for (Breakpoint breakpoint : breakpointManager.getBreakpoints()) {
            BreakpointTarget target = breakpoint.getTarget();
            if (!(target instanceof ScriptRegExpBreakpointTarget) || this.isAnyFirstLineBreakpoint(breakpoint) || !breakpoint.getEnabled() || breakpoint.getLine() != location.getLine() || breakpoint.getColumn() != Breakpoint.Companion.EMPTY_VALUE && breakpoint.getColumn() != location.getColumn()) continue;
            String string = newTarget.toString();
            String string2 = target.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"target.toString()");
            if (!StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
            return breakpoint;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final String createNameRegExp(Location location) {
        block4: {
            block3: {
                property = System.getProperty("js.debug.url.case.sensitive");
                if (property != null) break block3;
                v0 = SystemInfoRt.isFileSystemCaseSensitive && !this.debugProcess.isFilesOnlyInLocalFileSystem();
                break block4;
            }
            var4_3 = property;
            if (var4_3.length() == 0) ** GOTO lbl-1000
            var4_3 = property;
            if (Boolean.parseBoolean((String)var4_3)) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = useCaseSensitiveUrl = false;
            }
        }
        if (this.debugProcess.isFilesOnlyInLocalFileSystem() && this.debugProcess instanceof FilePathRegExpCreator) {
            v1 = (FilePathRegExpCreator)this.debugProcess;
            v2 = location.getUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"location.url");
            return v1.createFilePathRegExp(v2, this.debugProcess);
        }
        return JavaScriptLineBreakpointManagerKt.access$createUrlRegExp(location, useCaseSensitiveUrl);
    }

    public final void sourceMapNotFound(@NotNull XLineBreakpoint<?> breakpoint, @NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        this.actualLocationNotFound.computeIfAbsent(vm, sourceMapNotFound.1.INSTANCE).add(breakpoint);
    }

    @NotNull
    public final List<Pair<XLineBreakpoint<?>, List<Location>>> sourceMapFound(@NotNull Vm vm, @NotNull SourceMap map, @Nullable Script script, @Nullable Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Set set = (Set)this.actualLocationNotFound.get(vm);
        if (set == null) {
            return CollectionsKt.emptyList();
        }
        Set actualLocationNotFound = set;
        if (actualLocationNotFound.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List sourceMapFound = null;
        Iterator iterator = actualLocationNotFound.iterator();
        while (iterator.hasNext()) {
            List<Location> actualLocations;
            List<Location> list;
            XLineBreakpoint breakpoint = (XLineBreakpoint)iterator.next();
            Project project = this.debugProcess.getSession().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
            SourceInfo lambdaPosition = PsiVisitorKt.getLambdaPosition(breakpoint, project);
            if (breakpoint.getSourcePosition() != null) {
                XSourcePosition xSourcePosition;
                XSourcePosition it = xSourcePosition;
                List<Url> list2 = this.debugProcess.getFinder().getRemoteUrls(it.getFile());
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"debugProcess.finder.getRemoteUrls(it.file)");
                VirtualFile virtualFile = it.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it.file");
                SourceInfo sourceInfo = lambdaPosition;
                list = SourceMapHelperKt.getRawLocations(this.debugProcess, list2, virtualFile, it.getLine(), map, script, scriptUrl, sourceInfo != null ? sourceInfo.getColumn() : -1);
            } else {
                list = null;
            }
            if (UtilKt.isNullOrEmpty(actualLocations = list)) continue;
            iterator.remove();
            if (sourceMapFound == null) {
                sourceMapFound = (List)new SmartList();
            }
            List<Location> list3 = actualLocations;
            if (list3 == null) {
                Intrinsics.throwNpe();
            }
            sourceMapFound.add(new Pair((Object)breakpoint, list3));
        }
        List list = sourceMapFound;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<XLineBreakpoint<?>> findTopFirstLineBreakpoints(@NotNull SuspendContext<?> context, @NotNull String scriptName) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)scriptName, (String)"scriptName");
        CallFrame callFrame = context.getTopFrame();
        int breakLine = callFrame != null ? callFrame.getLine() : 0;
        for (Breakpoint breakpoint : context.getVm().getBreakpointManager().getBreakpoints()) {
            boolean bl;
            if (this.isAnyFirstLineBreakpoint(breakpoint) || !breakpoint.getEnabled() || breakpoint.getLine() != 0 && breakpoint.getLine() != breakLine) continue;
            BreakpointTarget breakpointTarget = breakpoint.getTarget();
            BreakpointTarget breakpointTarget2 = breakpointTarget;
            if (breakpointTarget2 instanceof ScriptRegExpBreakpointTarget) {
                String string = breakpointTarget.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"breakpointTarget.toString()");
                bl = JavaScriptLineBreakpointManagerKt.match(string, scriptName);
            } else {
                Script script;
                bl = breakpointTarget2 instanceof BreakpointTarget.ScriptName ? Intrinsics.areEqual((Object)scriptName, (Object)breakpointTarget.toString()) : (breakpointTarget2 instanceof BreakpointTarget.ScriptId ? Intrinsics.areEqual((Object)scriptName, (Object)(script = ((BreakpointTarget.ScriptId)breakpointTarget).script).getUrl().trimParameters().toExternalForm()) || Intrinsics.areEqual((Object)scriptName, (Object)script.getUrl().trimParameters().toDecodedForm()) : false);
            }
            if (!bl) continue;
            List list = (List)this.getVmToIdeBreakpoints().get((Object)breakpoint);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final List<XLineBreakpoint<?>> findBreakpoints(@NotNull Breakpoint vmBreakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)vmBreakpoint, (String)"vmBreakpoint");
        List list = (List)this.getVmToIdeBreakpoints().get((Object)vmBreakpoint);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Collection<XLineBreakpoint<?>> findBreakpoints(@NotNull List<? extends Breakpoint> breakpointsHit) {
        List list;
        block1: {
            Intrinsics.checkParameterIsNotNull(breakpointsHit, (String)"breakpointsHit");
            List<? extends Breakpoint> $receiver$iv = breakpointsHit;
            Iterator<? extends Breakpoint> iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                Breakpoint file$iv;
                Breakpoint it = file$iv = iterator.next();
                List result$iv = UtilKt.nullize((List)((List)this.getVmToIdeBreakpoints().get((Object)it)));
                if (result$iv == null) continue;
                list = result$iv;
                break block1;
            }
            list = null;
        }
        List list2 = list;
        return list2 != null ? (Collection)list2 : (Collection)CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<Breakpoint> doRunToLocation(@NotNull XSourcePosition position) {
        List list;
        List<Url> urls;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        List<Url> list2 = urls = this.debugProcess.getFinder().getRemoteUrls(position.getFile());
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"urls");
        List locations = SourceMapHelperKt.getRawLocations$default(this.debugProcess, list2, position, null, null, null, 56, null);
        if (locations.isEmpty() && this.debugProcess.getFinder().isOnlySourceMappedBreakpoints(position.getFile())) {
            String message = "Cannot run to location, source location is not mapped: " + position.toString();
            this.debugProcess.getSession().reportError(message);
            JavaScriptDebugProcessKt.getLOG().warn(message);
            return CollectionsKt.emptyList();
        }
        if (locations.isEmpty()) {
            Vm vm = this.debugProcess.getActiveOrMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            list = CollectionsKt.listOfNotNull((Object)LineBreakpointManager.doSetBreakpoint$default((LineBreakpointManager)this, (Vm)vm, (XLineBreakpoint)null, (Location)new Location((Url)CollectionsKt.first(urls), position.getLine(), position instanceof SourceInfo ? ((SourceInfo)position).getColumn() : -1), (boolean)true, null, (int)16, null));
        } else {
            void destination$iv$iv;
            void $receiver$iv$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable message = locations;
            void var5_6 = $receiver$iv;
            Collection collection = new ArrayList();
            void var7_8 = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Boolean bl;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                Location it = (Location)element$iv$iv;
                Vm vm = this.debugProcess.getActiveOrMainVm();
                if (vm == null) {
                    Intrinsics.throwNpe();
                }
                if (LineBreakpointManager.doSetBreakpoint$default((LineBreakpointManager)this, (Vm)vm, (XLineBreakpoint)null, (Location)it, (boolean)true, null, (int)16, null) != null) {
                    Breakpoint breakpoint;
                    Breakpoint it$iv$iv = breakpoint;
                    bl = destination$iv$iv.add(it$iv$iv);
                    continue;
                }
                bl = null;
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public JavaScriptLineBreakpointManager(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super((DebugProcessImpl)debugProcess);
        this.debugProcess = debugProcess;
        this.anyFirstLineBreakpoints = ContainerUtil.createConcurrentList();
        this.actualLocationNotFound = ContainerUtil.newConcurrentMap();
    }
}

