/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.jetbrains.javascript.debugger.FunctionStepIntoVariant;
import com.jetbrains.javascript.debugger.LineVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/javascript/debugger/VariantsCollector;", "Lcom/jetbrains/javascript/debugger/LineVisitor;", "()V", "variants", "", "Lcom/jetbrains/javascript/debugger/FunctionStepIntoVariant;", "getVariants", "()Ljava/util/List;", "setVariants", "(Ljava/util/List;)V", "addVariant", "", "element", "Lcom/intellij/lang/javascript/psi/ecmal4/JSQualifiedNamedElement;", "isFunctionAdded", "", "function", "Lcom/intellij/lang/javascript/psi/JSFunction;", "visitJSCallExpression", "callExpression", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "JavaScriptDebugger"})
final class VariantsCollector
extends LineVisitor {
    @Nullable
    private List<FunctionStepIntoVariant> variants;

    @Nullable
    public final List<FunctionStepIntoVariant> getVariants() {
        return this.variants;
    }

    public final void setVariants(@Nullable List<FunctionStepIntoVariant> list) {
        this.variants = list;
    }

    public void visitJSCallExpression(@NotNull JSCallExpression callExpression) {
        String name;
        JSFunction function;
        Intrinsics.checkParameterIsNotNull((Object)callExpression, (String)"callExpression");
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && (function = JSPsiImplUtils.getPossibleFunction((PsiElement)((JSReferenceExpression)methodExpression).resolve())) != null && (name = function.getName()) != null && !this.isFunctionAdded(function)) {
            this.addVariant((JSQualifiedNamedElement)function);
        }
    }

    private final boolean isFunctionAdded(JSFunction function) {
        if (this.variants == null) {
            return false;
        }
        List<FunctionStepIntoVariant> list = this.variants;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (FunctionStepIntoVariant variant : list) {
            if (!Intrinsics.areEqual((Object)function, (Object)((JSQualifiedNamedElement)variant.getElement()))) continue;
            return true;
        }
        return false;
    }

    private final void addVariant(JSQualifiedNamedElement element) {
        if (this.variants == null) {
            this.variants = (List)new SmartList();
        }
        List<FunctionStepIntoVariant> list = this.variants;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        list.add(new FunctionStepIntoVariant(element));
    }
}

