/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.execution;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipEmptySerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.jetbrains.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggableProcessRunConfigurationBase
extends LocatableConfigurationBase
implements DebuggableProcessRunConfiguration,
RefactoringListenerProvider {
    private static final SerializationFilter SERIALIZATION_FILTER = new SkipEmptySerializationFilter(){

        protected ThreeState accepts(@NotNull String name, @NotNull Object beanValue) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationBase$1", "accepts"));
            }
            if (beanValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanValue", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationBase$1", "accepts"));
            }
            return name.equals("passParentEnvs") ? ThreeState.fromBoolean((boolean)Boolean.FALSE.equals(beanValue)) : ThreeState.UNSURE;
        }
    };
    private String inputPath;
    private String programParameters;
    private String workingDirectory;
    private String exePath;
    private Map<String, String> environments = new THashMap();
    private boolean passParentEnvs = true;

    protected DebuggableProcessRunConfigurationBase(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @Override
    @Attribute
    public String getExePath() {
        return this.exePath;
    }

    public void setExePath(@Nullable String value) {
        this.exePath = PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value));
    }

    @Override
    @Attribute
    @Nullable
    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(@Nullable String value) {
        this.inputPath = PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value));
    }

    @Attribute
    @Nullable
    public String getProgramParameters() {
        return this.programParameters;
    }

    public void setProgramParameters(@Nullable String value) {
        this.programParameters = StringUtil.nullize((String)value);
    }

    @Attribute
    @Nullable
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.workingDirectory = PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value));
    }

    @MapAnnotation(surroundKeyWithTag=false, surroundValueWithTag=false, surroundWithTag=false)
    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.environments;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationBase", "getEnvs"));
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationBase", "setEnvs"));
        }
        this.environments = value;
    }

    @Attribute
    public boolean isPassParentEnvs() {
        return this.passParentEnvs;
    }

    public void setPassParentEnvs(boolean value) {
        this.passParentEnvs = value;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this, (Element)element, (SerializationFilter)SERIALIZATION_FILTER);
    }

    protected final void _writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this, (Element)element);
        Project project = this.getProject();
        if (project != null) {
            PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)project);
            this.inputPath = pathMacroManager.collapsePath(this.inputPath);
            this.exePath = pathMacroManager.collapsePath(this.exePath);
            this.workingDirectory = pathMacroManager.collapsePath(this.workingDirectory);
            this.programParameters = pathMacroManager.collapsePath(this.programParameters);
        }
    }

    protected final void _readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
    }

    public RunConfiguration clone() {
        DebuggableProcessRunConfigurationBase clone = (DebuggableProcessRunConfigurationBase)super.clone();
        clone.environments = new THashMap(this.environments);
        return super.clone();
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (Comparing.equal((Object)PsiUtilBase.asVirtualFile((PsiElement)element), (Object)DebuggableProcessRunConfigurationBase.findInputVirtualFile(this))) {
            return new FilePathRefactoringElementListener(this, true);
        }
        return null;
    }

    @Override
    @Nullable
    public String getEffectiveWorkingDirectory() {
        String workingDir = this.getWorkingDirectory();
        if (workingDir == null) {
            return this.getProject().getBasePath();
        }
        return FileUtilRt.toSystemDependentName((String)PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPath(workingDir));
    }

    @Override
    @Nullable
    public final String getEffectiveExePath() {
        String path = this.getExePath();
        if (path != null) {
            return PathUtil.toSystemDependentName((String)PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPath(path));
        }
        return this.computeDefaultExePath();
    }

    @Nullable
    protected abstract String computeDefaultExePath();

    public void checkConfiguration() throws RuntimeConfigurationException {
        File workingDir;
        String workingDirectoryPath = this.getEffectiveWorkingDirectory();
        File file = workingDir = workingDirectoryPath == null ? null : new File(workingDirectoryPath);
        if (workingDir == null || !workingDir.isAbsolute() || !workingDir.isDirectory()) {
            throw new RuntimeConfigurationError("Please specify working directory correctly");
        }
        VirtualFile file2 = DebuggableProcessRunConfigurationBase.findInputVirtualFile(this);
        if (file2 == null || !file2.isValid()) {
            throw new RuntimeConfigurationError("Please specify path to " + this.getInputFileTitle() + " correctly");
        }
    }

    @NotNull
    protected abstract String getInputFileTitle();

    protected final void checkExePath(@NotNull String appName) throws RuntimeConfigurationError {
        if (appName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appName", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationBase", "checkExePath"));
        }
        String exePath = this.getEffectiveExePath();
        String exePathProblem = null;
        if (StringUtil.isEmpty((String)exePath)) {
            exePathProblem = "Path to " + appName + " executable is empty";
        } else {
            File file = new File(this.correctExePath(exePath));
            if (!file.isFile()) {
                exePathProblem = "Path to " + appName + " is not correct";
            }
        }
        if (exePathProblem != null) {
            throw new RuntimeConfigurationError(exePathProblem);
        }
    }

    @Override
    @NotNull
    public String correctExePath(@NotNull String exePath) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationBase", "correctExePath"));
        }
        String string = exePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationBase", "correctExePath"));
        }
        return string;
    }

    @Nullable
    public static VirtualFile findInputVirtualFile(@NotNull DebuggableProcessRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationBase", "findInputVirtualFile"));
        }
        String inputPath = configuration.getInputPath();
        if (inputPath == null) {
            return null;
        }
        VirtualFile result = LocalFileSystem.getInstance().findFileByPath(PathMacroManager.getInstance((ComponentManager)configuration.getProject()).expandPath(inputPath));
        if (result == null) {
            VirtualFile workingDir;
            VirtualFile virtualFile = workingDir = configuration.getWorkingDirectory() == null ? null : LocalFileSystem.getInstance().findFileByPath(configuration.getWorkingDirectory());
            if (workingDir != null) {
                result = workingDir.findFileByRelativePath(inputPath);
            }
        }
        return result;
    }

    public static class FilePathRefactoringElementListener
    extends UndoRefactoringElementAdapter {
        private final DebuggableProcessRunConfigurationBase configuration;
        private final boolean isInputPath;

        public FilePathRefactoringElementListener(@NotNull DebuggableProcessRunConfigurationBase configuration, boolean isInputPath) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationBase$FilePathRefactoringElementListener", "<init>"));
            }
            this.configuration = configuration;
            this.isInputPath = isInputPath;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationBase$FilePathRefactoringElementListener", "refactored"));
            }
            VirtualFile newFile = PsiUtilBase.asVirtualFile((PsiElement)element);
            if (newFile != null && this.isInputPath) {
                String newInputPath;
                VirtualFile workingDir;
                String workingDirectoryPath = this.configuration.getEffectiveWorkingDirectory();
                VirtualFile virtualFile = workingDir = workingDirectoryPath == null ? null : LocalFileSystem.getInstance().findFileByPath(workingDirectoryPath);
                if (workingDir != null && workingDir.isDirectory() && (newInputPath = VfsUtilCore.getRelativePath((VirtualFile)workingDir, (VirtualFile)newFile, (char)'/')) != null) {
                    this.configuration.setInputPath(newInputPath);
                }
            }
        }
    }
}

