/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap.visualizer.actions;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.actions.VisualizeSourceMapActionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/javascript/debugger/sourcemap/visualizer/actions/VisualizeSourceMapAction;", "Lcom/jetbrains/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction;", "()V", "perform", "", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "JavaScriptDebugger"})
public final class VisualizeSourceMapAction
extends BaseSourceMapAction {
    @Override
    protected void perform(@NotNull SourceMap map, @NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile generatedFile = null;
        if (map.getOutFile() == null) {
            String fileName = file.getName();
            if (StringsKt.endsWith$default((String)fileName, (String)".map", (boolean)false, (int)2, null)) {
                generatedFile = file.getParent().findChild(StringsKt.removeSuffix((String)fileName, (CharSequence)".map"));
            }
        } else {
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = file.getParent();
            String string = map.getOutFile();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((virtualFile = virtualFile2.findFileByRelativePath(string)) == null) {
                String string2 = map.getOutFile();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                virtualFile = generatedFile = LocalFileFinder.findFile((String)string2);
            }
        }
        if (generatedFile == null) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)((FileType)JavaScriptFileType.INSTANCE));
            descriptor.setTitle("Select Generated File");
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)file.getParent(), (Consumer)((Consumer)new Consumer<VirtualFile>(map, project){
                final /* synthetic */ SourceMap $map;
                final /* synthetic */ Project $project;

                public final void consume(VirtualFile it) {
                    VirtualFile virtualFile = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                    VisualizeSourceMapActionKt.visualizeMap$default(this.$map, virtualFile, null, this.$project, null, 16, null);
                }
                {
                    this.$map = sourceMap;
                    this.$project = project;
                }
            }));
        } else {
            VisualizeSourceMapActionKt.visualizeMap$default(map, generatedFile, null, project, null, 16, null);
        }
    }
}

