/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.tagtoattribute;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;

class TagToAttributeDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JTextField attributeNameField;
    private final XmlTag tag;

    TagToAttributeDialog(XmlTag tag) {
        super(tag.getProject(), true);
        String tagName = tag.getName();
        this.tag = tag;
        XmlTag parentTag = tag.getParentTag();
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle("Replace Tag With Attribute");
        this.attributeNameLabel.setText("Name for new attribute");
        XmlAttribute[] attributes = parentTag.getAttributes();
        String attributeName = null;
        for (XmlAttribute attribute : attributes) {
            if (attribute == null) continue;
            attributeName = attribute.getLocalName();
            break;
        }
        String newAttributeName = TagToAttributeDialog.attributeNameFromTag(tagName, attributeName);
        this.attributeNameField = new JTextField(newAttributeName);
        Document document = this.attributeNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.TagToAttribute";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.attributeNameField;
    }

    private static String attributeNameFromTag(String tagName, String attributeName) {
        int colonIndex = tagName.indexOf(58);
        if (colonIndex >= 0) {
            String prefix = tagName.substring(0, colonIndex + 1);
            String suffix = tagName.substring(colonIndex + 1);
            return prefix + TagToAttributeDialog.matchCase(suffix, attributeName);
        }
        return TagToAttributeDialog.matchCase(tagName, attributeName);
    }

    public static String matchCase(String stringToMatch, String stringMatched) {
        if (stringMatched == null || stringMatched.length() == 0) {
            return stringToMatch.toLowerCase();
        }
        if (TagToAttributeDialog.isAllLowerCase(stringMatched)) {
            return stringToMatch.toLowerCase();
        }
        if (TagToAttributeDialog.isAllUpperCase(stringMatched)) {
            return stringToMatch.toUpperCase();
        }
        char startingChar = stringMatched.charAt(0);
        if (Character.isLowerCase(startingChar)) {
            return Character.toLowerCase(stringToMatch.charAt(0)) + stringToMatch.substring(1);
        }
        if (Character.isUpperCase(startingChar)) {
            return Character.toUpperCase(stringToMatch.charAt(0)) + stringToMatch.substring(1);
        }
        return stringToMatch;
    }

    private static boolean isAllLowerCase(String string) {
        char[] chars;
        for (char c : chars = string.toCharArray()) {
            if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllUpperCase(String string) {
        char[] chars;
        for (char c : chars = string.toCharArray()) {
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public String getAttributeName() {
        String text = this.attributeNameField.getText();
        return text.trim();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)("Replace tag " + tagName + " with attribute"), (boolean)true);
        panel.add((Component)this.attributeNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder((Border)border);
        this.attributeNameField.setEditable(true);
        box.add(this.attributeNameField);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        String attributeName = this.getAttributeName();
        boolean attributeNameEntered = XMLUtil.attributeNameIsValid(attributeName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return attributeNameEntered && scopeIsValid;
    }

    @Override
    protected String calculateXSLT() {
        String parentTagname = this.tag.getParentTag().getName();
        String tagName = this.tag.getName();
        String attributeName = this.getAttributeName();
        return " <xsl:template match=\"" + parentTagname + "\">\n" + "\t<xsl:copy> \n" + "\t\t<xsl:for-each select =\"child::" + tagName + "\">\n" + "\t\t\t<xsl:attribute name = \"" + attributeName + "\">\n" + "\t\t\t\t<xsl:value-of select=\".\"/>\n" + "\t\t\t</xsl:attribute>\n" + "\t\t</xsl:for-each>\n" + "\t\t<xsl:apply-templates select=\"@*|node()\"/>\n" + "\t</xsl:copy>\n" + "</xsl:template>\n" + "<xsl:template match=\"" + parentTagname + "/" + tagName + "\"/>";
    }

    @Override
    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactoring.tagToAttribute");
    }
}

