/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.impl.OracleHelper;
import com.intellij.database.remote.jdbc.impl.PostgresHelper;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.RemoteBlobImpl;
import com.intellij.database.remote.jdbc.impl.RemoteClobImpl;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.openapi.util.Getter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcRemoteObject
extends RemoteObject {
    static final String FAILED_TO_LOAD = "<failed to load>";

    public Object wrapIfNeeded(Object o, Getter<Connection> connectionGetter) throws RemoteException, SQLException {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        String className = c.getName();
        if (o instanceof Clob) {
            return this.export2((Remote)((Object)RemoteClobImpl.wrap((Clob)o)));
        }
        if (o instanceof Blob) {
            return this.export2((Remote)((Object)RemoteBlobImpl.wrap((Blob)o)));
        }
        if (o instanceof Array) {
            int type = ((Array)o).getBaseType();
            if (type == 1111) {
                return o.toString();
            }
            Object array = ((Array)o).getArray();
            return this.wrapIfNeeded(array, connectionGetter);
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            Object[] result = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.wrapIfNeeded(array[i], connectionGetter);
            }
            return result;
        }
        if (className.startsWith("oracle.")) {
            Object value = OracleHelper.convertValue(this, className, o, connectionGetter);
            if (value != null) {
                return value;
            }
        } else {
            if (o instanceof Timestamp) {
                return c != Timestamp.class ? new Timestamp(((Timestamp)o).getTime()) : o;
            }
            if (o instanceof Time) {
                return c != Time.class ? new Time(((Time)o).getTime()) : o;
            }
            if (o instanceof Date) {
                return c != Date.class ? new Date(((Date)o).getTime()) : o;
            }
            if (o instanceof java.util.Date) {
                return c != java.util.Date.class ? new java.util.Date(((java.util.Date)o).getTime()) : o;
            }
            if (className.startsWith("org.postgresql")) {
                Object result = PostgresHelper.convertValue(className, o);
                if (result != null) {
                    return result;
                }
            } else if (className.startsWith("com.ibm.db2") && className.equals("com.ibm.db2.jcc.am.ke")) {
                return ReflectionHelper.tryInvokeMethod(o, "getString", null, null);
            }
        }
        if (c.getClassLoader() == null || className.startsWith("com.intellij")) {
            return o;
        }
        String stringValue = o.toString();
        return stringValue.startsWith(className) ? "<failed to load> " + className : stringValue;
    }

    public Throwable wrapException(Throwable ex) {
        if (ex instanceof SQLException) {
            return this.wrapSqlException((SQLException)ex);
        }
        return super.wrapException(ex);
    }

    @Nullable
    private SQLException wrapSqlException(@Nullable SQLException target) {
        SQLException result = null;
        SQLException prev = null;
        for (SQLException ex = target; ex != null; ex = ex.getNextException()) {
            SQLException w = new SQLException(ex.getLocalizedMessage(), ex.getSQLState(), ex.getErrorCode());
            w.setStackTrace(ex.getStackTrace());
            w.initCause(this.wrapException(ex.getCause()));
            if (prev == null) {
                result = prev = w;
                continue;
            }
            prev.setNextException(w);
        }
        return result;
    }

    @Nullable
    public SQLWarning wrapSqlWarning(@Nullable SQLWarning target) {
        SQLWarning result = null;
        SQLWarning prev = null;
        for (SQLWarning ex = target; ex != null; ex = ex.getNextWarning()) {
            SQLWarning w = new SQLWarning(ex.getLocalizedMessage(), ex.getSQLState(), ex.getErrorCode());
            w.setStackTrace(ex.getStackTrace());
            w.initCause(this.wrapException(ex.getCause()));
            if (prev == null) {
                result = prev = w;
                continue;
            }
            prev.setNextWarning(w);
        }
        return result;
    }

    public RuntimeException rethrowException(Throwable e) throws SQLException, RemoteException {
        Throwable wrap = this.wrapException(e);
        if (wrap instanceof SQLException) {
            throw (SQLException)wrap;
        }
        throw wrap instanceof RuntimeException ? (RuntimeException)wrap : new RuntimeException(wrap);
    }

    public RuntimeException rethrowRuntimeException(Throwable e) throws RemoteException {
        Throwable wrap = this.wrapException(e);
        throw wrap instanceof RuntimeException ? (RuntimeException)wrap : new RuntimeException(wrap);
    }
}

