/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaFeatureRunConfigurationProducer;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;

public class CucumberJavaScenarioRunConfigurationProducer
extends CucumberJavaFeatureRunConfigurationProducer {
    @Override
    protected String getNameFilter(@NotNull ConfigurationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaScenarioRunConfigurationProducer", "getNameFilter"));
        }
        PsiElement sourceElement = context.getPsiLocation();
        GherkinStepsHolder scenario = (GherkinStepsHolder)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, (Class[])new Class[]{GherkinScenario.class, GherkinScenarioOutline.class});
        if (scenario != null) {
            return "^" + StringUtil.escapeToRegexp((String)scenario.getScenarioName()) + "$";
        }
        return super.getNameFilter(context);
    }

    @Override
    @Nullable
    protected VirtualFile getFileToRun(ConfigurationContext context) {
        PsiElement element = context.getPsiLocation();
        GherkinStepsHolder scenario = (GherkinStepsHolder)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GherkinScenario.class, GherkinScenarioOutline.class});
        PsiFile psiFile = scenario != null ? scenario.getContainingFile() : null;
        return psiFile != null ? psiFile.getVirtualFile() : null;
    }

    @Override
    protected String getConfigurationName(@NotNull ConfigurationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaScenarioRunConfigurationProducer", "getConfigurationName"));
        }
        PsiElement sourceElement = context.getPsiLocation();
        GherkinStepsHolder scenario = (GherkinStepsHolder)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, (Class[])new Class[]{GherkinScenario.class, GherkinScenarioOutline.class});
        return "Scenario: " + (scenario != null ? scenario.getScenarioName() : "");
    }
}

