/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionUtil {
    private ActionUtil() {
    }

    static boolean matchesPath(@NotNull @NonNls String actionPath, @NotNull @NonNls String checkPath) {
        String strippedCheckPath;
        if (actionPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionPath", "com/intellij/struts2/dom/struts/impl/ActionUtil", "matchesPath"));
        }
        if (checkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkPath", "com/intellij/struts2/dom/struts/impl/ActionUtil", "matchesPath"));
        }
        int bangIdx = StringUtil.indexOf((CharSequence)checkPath, (char)'!');
        String string = strippedCheckPath = bangIdx == -1 ? checkPath : checkPath.substring(0, bangIdx);
        if (StringUtil.indexOf((CharSequence)actionPath, (char)'*') == -1) {
            return Comparing.equal((String)strippedCheckPath, (String)actionPath);
        }
        return Pattern.matches(StringUtil.replace((String)actionPath, (String)"*", (String)"[^/]*"), strippedCheckPath);
    }

    static List<PsiMethod> findActionMethods(@NotNull PsiClass actionClass, @Nullable String methodName) {
        PsiMethod[] methods;
        if (actionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionClass", "com/intellij/struts2/dom/struts/impl/ActionUtil", "findActionMethods"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)actionClass);
        if (module == null) {
            return Collections.emptyList();
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        PsiClassType stringType = PsiType.getJavaLangString((PsiManager)actionClass.getManager(), (GlobalSearchScope)scope);
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)actionClass.getProject()).getElementFactory();
        PsiClassType resultType = psiElementFactory.createTypeByFQClassName("com.opensymphony.xwork2.Result", scope);
        boolean searchForMethod = methodName != null;
        SmartList actionMethods = new SmartList();
        for (PsiMethod psiMethod : methods = searchForMethod ? actionClass.findMethodsByName(methodName, true) : actionClass.getAllMethods()) {
            PsiType type;
            String psiMethodName;
            PsiModifierList modifiers;
            if (psiMethod.isConstructor() || !(modifiers = psiMethod.getModifierList()).hasModifierProperty("public") || modifiers.hasModifierProperty("static") || modifiers.hasModifierProperty("abstract") || psiMethod.getParameterList().getParametersCount() != 0 || Comparing.equal((String)(psiMethodName = psiMethod.getName()), (String)"toString") || PropertyUtil.isSimplePropertyGetter((PsiMethod)psiMethod) && actionClass.findFieldByName(PropertyUtil.getPropertyName((PsiMethod)psiMethod), true) != null || (type = psiMethod.getReturnType()) == null || !(type instanceof PsiClassType) || !type.equals(stringType) && !type.equals(resultType)) continue;
            if (searchForMethod) {
                return Collections.singletonList(psiMethod);
            }
            Condition nameCondition = method -> psiMethodName.equals(method.getName());
            if (ContainerUtil.exists((Iterable)actionMethods, (Condition)nameCondition)) continue;
            actionMethods.add(psiMethod);
        }
        return actionMethods;
    }
}

