/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FilePathReferenceProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.dom.ConverterUtil;
import com.intellij.struts2.dom.struts.IncludeFileResolvingConverter;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeFileResolvingConverterImpl
extends IncludeFileResolvingConverter {
    public PsiFile fromString(@Nullable @NonNls String value, ConvertContext context) {
        if (value == null) {
            return null;
        }
        XmlElement xmlElement = context.getReferenceXmlElement();
        if (xmlElement == null) {
            return null;
        }
        PsiReference[] references = this.createReferences((GenericDomValue)context.getInvocationElement(), (PsiElement)xmlElement, context);
        if (references.length == 0) {
            return null;
        }
        PsiElement element = references[references.length - 1].resolve();
        return element instanceof PsiFile ? (PsiFile)element : null;
    }

    @NotNull
    public Collection<? extends PsiFile> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/IncludeFileResolvingConverterImpl", "getVariants"));
        }
        return list;
    }

    public PsiElement resolve(PsiFile psiFile, ConvertContext context) {
        if (context.getFile().equals(psiFile)) {
            return null;
        }
        StrutsModel model = ConverterUtil.getStrutsModel(context);
        if (model == null) {
            return null;
        }
        return IncludeFileResolvingConverterImpl.isFileAccepted(model, psiFile) ? super.resolve((Object)psiFile, context) : null;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull GenericDomValue genericDomValue, @NotNull PsiElement element, @NotNull ConvertContext context) {
        if (genericDomValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/struts2/dom/struts/impl/IncludeFileResolvingConverterImpl", "createReferences"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts2/dom/struts/impl/IncludeFileResolvingConverterImpl", "createReferences"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts2/dom/struts/impl/IncludeFileResolvingConverterImpl", "createReferences"));
        }
        String s = genericDomValue.getStringValue();
        if (s == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/IncludeFileResolvingConverterImpl", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final StrutsModel model = ConverterUtil.getStrutsModel(context);
        if (model == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/IncludeFileResolvingConverterImpl", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        PsiReference[] psiReferenceArray = new FilePathReferenceProvider(){

            protected boolean isPsiElementAccepted(PsiElement element) {
                return super.isPsiElementAccepted(element) && (!(element instanceof PsiFile) || IncludeFileResolvingConverterImpl.isFileAccepted(model, (PsiFile)element));
            }
        }.getReferencesByElement(element, s, offset, true);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/IncludeFileResolvingConverterImpl", "createReferences"));
        }
        return psiReferenceArray;
    }

    public String getErrorMessage(@Nullable String value, ConvertContext context) {
        if (Comparing.equal((String)context.getFile().getName(), (String)value)) {
            return "Recursive inclusion of current file";
        }
        return "Cannot resolve file ''" + value + "'' (not in file set of including file?)";
    }

    private static boolean isFileAccepted(@NotNull StrutsModel model, @NotNull PsiFile file) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/struts2/dom/struts/impl/IncludeFileResolvingConverterImpl", "isFileAccepted"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/struts2/dom/struts/impl/IncludeFileResolvingConverterImpl", "isFileAccepted"));
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)file;
        Set files = model.getConfigFiles();
        return files.contains(xmlFile);
    }
}

