/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl.path;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.struts2.dom.struts.HasResultType;
import com.intellij.struts2.dom.struts.strutspackage.ResultType;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StrutsResultContributor
implements PathReferenceProvider {
    public static final ExtensionPointName<StrutsResultContributor> EP_NAME = new ExtensionPointName("com.intellij.struts2.resultContributor");

    protected abstract boolean matchesResultType(@NonNls @NotNull String var1);

    @Nullable
    protected final String getNamespace(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/dom/struts/impl/path/StrutsResultContributor", "getNamespace"));
        }
        DomElement resultElement = DomUtil.getDomElement((PsiElement)psiElement);
        if (resultElement == null) {
            return null;
        }
        assert (resultElement instanceof HasResultType) : "not instance of HasResultType: " + resultElement + ", text: " + psiElement.getText();
        ResultType effectiveResultType = ((HasResultType)resultElement).getEffectiveResultType();
        if (effectiveResultType == null) {
            return null;
        }
        String resultType = effectiveResultType.getName().getStringValue();
        if (resultType == null || !this.matchesResultType(resultType)) {
            return null;
        }
        StrutsPackage strutsPackage = (StrutsPackage)resultElement.getParentOfType(StrutsPackage.class, true);
        if (strutsPackage == null) {
            return null;
        }
        return strutsPackage.searchNamespace();
    }

    @Nullable
    protected PathReference createDefaultPathReference(String path, PsiElement element, @Nullable Icon staticIcon) {
        ArrayList list = new ArrayList(5);
        this.createReferences(element, list, true);
        if (list.isEmpty()) {
            return null;
        }
        final PsiElement target = ((PsiReference)list.get(list.size() - 1)).resolve();
        if (target == null) {
            return null;
        }
        Object iconFunction = staticIcon == null ? webPath -> target.getIcon(2) : new ConstantFunction((Object)staticIcon);
        return new PathReference(path, (Function)iconFunction){

            public PsiElement resolve() {
                return target;
            }
        };
    }
}

