/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class CompilerPaths {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.compiler.CompilerPaths");
    private static volatile String ourSystemPath;
    private static final Comparator<String> URLS_COMPARATOR;

    public static File getGeneratedDataDirectory(Project project, Compiler compiler) {
        return new File(CompilerPaths.getGeneratedDataDirectory(project), compiler.getDescription().replaceAll("\\s+", "_"));
    }

    public static File getGeneratedDataDirectory(Project project) {
        return new File(CompilerPaths.getCompilerSystemDirectory(project), ".generated");
    }

    public static File getCacheStoreDirectory(Project project) {
        return new File(CompilerPaths.getCompilerSystemDirectory(project), ".caches");
    }

    public static File getCacheStoreDirectory(String compilerProjectDirName) {
        return new File(CompilerPaths.getCompilerSystemDirectory(compilerProjectDirName), ".caches");
    }

    public static File getRebuildMarkerFile(Project project) {
        return new File(CompilerPaths.getCompilerSystemDirectory(project), "rebuild_required");
    }

    public static File getCompilerSystemDirectory(Project project) {
        return CompilerPaths.getCompilerSystemDirectory(CompilerPaths.getCompilerSystemDirectoryName(project));
    }

    public static File getCompilerSystemDirectory(String compilerProjectDirName) {
        return new File(CompilerPaths.getCompilerSystemDirectory(), compilerProjectDirName);
    }

    public static String getCompilerSystemDirectoryName(Project project) {
        return ProjectUtilCore.getPresentableName(project) + "." + project.getLocationHash();
    }

    public static File getCompilerSystemDirectory() {
        String systemPath = ourSystemPath != null ? ourSystemPath : (ourSystemPath = PathUtil.getCanonicalPath(PathManager.getSystemPath()));
        return new File(systemPath, "compiler");
    }

    @Nullable
    public static VirtualFile getModuleOutputDirectory(Module module, boolean forTestClasses) {
        VirtualFile path2;
        CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance(module);
        if (compilerModuleExtension == null) {
            return null;
        }
        VirtualFile outPath = forTestClasses ? ((path2 = compilerModuleExtension.getCompilerOutputPathForTests()) != null ? path2 : compilerModuleExtension.getCompilerOutputPath()) : compilerModuleExtension.getCompilerOutputPath();
        if (outPath == null) {
            return null;
        }
        if (!outPath.isValid()) {
            LOG.info("Requested output path for module " + module.getName() + " is not valid");
            return null;
        }
        return outPath;
    }

    @Nullable
    public static String getModuleOutputPath(Module module, boolean forTestClasses) {
        String url;
        Application application = ApplicationManager.getApplication();
        final CompilerModuleExtension extension = CompilerModuleExtension.getInstance(module);
        if (extension == null) {
            return null;
        }
        String outPathUrl = forTestClasses ? (application.isDispatchThread() ? ((url = extension.getCompilerOutputUrlForTests()) != null ? url : extension.getCompilerOutputUrl()) : application.runReadAction(new Computable<String>(){

            public String compute() {
                String url = extension.getCompilerOutputUrlForTests();
                return url != null ? url : extension.getCompilerOutputUrl();
            }
        })) : (application.isDispatchThread() ? extension.getCompilerOutputUrl() : application.runReadAction(new Computable<String>(){

            public String compute() {
                return extension.getCompilerOutputUrl();
            }
        }));
        return outPathUrl != null ? VirtualFileManager.extractPath(outPathUrl) : null;
    }

    @Nullable
    public static String getAnnotationProcessorsGenerationPath(Module module) {
        AnnotationProcessingConfiguration config = CompilerConfiguration.getInstance(module.getProject()).getAnnotationProcessingConfiguration(module);
        String sourceDirName = config.getGeneratedSourcesDirectoryName(false);
        if (config.isOutputRelativeToContentRoot()) {
            String[] roots = ModuleRootManager.getInstance(module).getContentRootUrls();
            if (roots.length == 0) {
                return null;
            }
            if (roots.length > 1) {
                Arrays.sort(roots, URLS_COMPARATOR);
            }
            return StringUtil.isEmpty((String)sourceDirName) ? VirtualFileManager.extractPath(roots[0]) : VirtualFileManager.extractPath(roots[0]) + "/" + sourceDirName;
        }
        String path2 = CompilerPaths.getModuleOutputPath(module, false);
        if (path2 == null) {
            return null;
        }
        return StringUtil.isEmpty((String)sourceDirName) ? path2 : path2 + "/" + sourceDirName;
    }

    static {
        URLS_COMPARATOR = (o1, o2) -> o1.compareTo((String)o2);
    }
}

