/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionProvider;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorNotificationPanel
extends JPanel
implements IntentionActionProvider {
    protected final JLabel myLabel = new JLabel();
    protected final JLabel myGearLabel = new JLabel();
    protected final JPanel myLinksPanel = new NonOpaquePanel(new HorizontalLayout(JBUI.scale((int)5)));

    public EditorNotificationPanel() {
        super(new BorderLayout());
        NonOpaquePanel panel = new NonOpaquePanel(new BorderLayout());
        panel.add("Center", this.myLabel);
        panel.add("East", this.myLinksPanel);
        panel.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)5));
        panel.setMinimumSize(new Dimension(0, 0));
        this.add("Center", panel);
        this.add("East", this.myGearLabel);
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
    }

    public void setText(String text) {
        this.myLabel.setText(text);
    }

    public EditorNotificationPanel text(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/EditorNotificationPanel", "text"));
        }
        this.myLabel.setText(text);
        return this;
    }

    public EditorNotificationPanel icon(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/EditorNotificationPanel", "icon"));
        }
        this.myLabel.setIcon(icon);
        return this;
    }

    @Override
    public Color getBackground() {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
        return color == null ? UIUtil.getToolTipBackground() : color;
    }

    public HyperlinkLabel createActionLabel(String text, @NonNls String actionId) {
        return this.createActionLabel(text, () -> this.executeAction(actionId));
    }

    public HyperlinkLabel createActionLabel(String text, final Runnable action) {
        HyperlinkLabel label = new HyperlinkLabel(text, this.getBackground());
        label.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                action.run();
            }
        });
        this.myLinksPanel.add(label);
        return label;
    }

    protected void executeAction(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        AnActionEvent event = AnActionEvent.createFromAnAction(action, null, "unknown", DataManager.getInstance().getDataContext(this));
        action.beforeActionPerformedUpdate(event);
        action.update(event);
        if (event.getPresentation().isEnabled() && event.getPresentation().isVisible()) {
            action.actionPerformed(event);
        }
    }

    @Override
    @Nullable
    public IntentionActionWithOptions getIntentionAction() {
        MyIntentionAction action = new MyIntentionAction();
        return action.getOptions().isEmpty() ? null : action;
    }

    private static class MySettingsOption
    implements IntentionAction,
    Iconable,
    LowPriorityAction {
        private final JLabel myLabel;

        private MySettingsOption(JLabel label) {
            this.myLabel = label;
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String string = EditorBundle.message("editor.notification.settings.option.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorNotificationPanel$MySettingsOption", "getText"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Editor notification settings" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorNotificationPanel$MySettingsOption", "getFamilyName"));
            }
            return "Editor notification settings";
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/EditorNotificationPanel$MySettingsOption", "isAvailable"));
            }
            return true;
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/EditorNotificationPanel$MySettingsOption", "invoke"));
            }
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 501, System.currentTimeMillis(), 0, 0, 0, 1, false));
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 502, System.currentTimeMillis(), 0, 0, 0, 1, false));
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 500, System.currentTimeMillis(), 0, 0, 0, 1, false));
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public Icon getIcon(@Iconable.IconFlags int flags) {
            return this.myLabel.getIcon();
        }
    }

    private static class MyLinkOption
    implements IntentionAction {
        private final HyperlinkLabel myLabel;

        private MyLinkOption(HyperlinkLabel label) {
            this.myLabel = label;
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String string = this.myLabel.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorNotificationPanel$MyLinkOption", "getText"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Editor notification option" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorNotificationPanel$MyLinkOption", "getFamilyName"));
            }
            return "Editor notification option";
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/EditorNotificationPanel$MyLinkOption", "isAvailable"));
            }
            return true;
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/EditorNotificationPanel$MyLinkOption", "invoke"));
            }
            this.myLabel.doClick();
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }
    }

    private class MyIntentionAction
    extends AbstractEmptyIntentionAction
    implements IntentionActionWithOptions,
    Iconable {
        private final List<IntentionAction> myOptions = new ArrayList<IntentionAction>();

        private MyIntentionAction() {
            for (Component component : EditorNotificationPanel.this.myLinksPanel.getComponents()) {
                if (!(component instanceof HyperlinkLabel)) continue;
                this.myOptions.add(new MyLinkOption((HyperlinkLabel)component));
            }
            if (EditorNotificationPanel.this.myGearLabel.getIcon() != null) {
                this.myOptions.add(new MySettingsOption(EditorNotificationPanel.this.myGearLabel));
            }
        }

        @Override
        @NotNull
        public List<IntentionAction> getOptions() {
            List<IntentionAction> list = this.myOptions;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorNotificationPanel$MyIntentionAction", "getOptions"));
            }
            return list;
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String text = EditorNotificationPanel.this.myLabel.getText();
            String string = StringUtil.isEmpty((String)text) ? EditorBundle.message("editor.notification.default.action.name", new Object[0]) : StringUtil.shortenTextWithEllipsis((String)text, (int)50, (int)0);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorNotificationPanel$MyIntentionAction", "getText"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Editor notification" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorNotificationPanel$MyIntentionAction", "getFamilyName"));
            }
            return "Editor notification";
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/EditorNotificationPanel$MyIntentionAction", "isAvailable"));
            }
            return true;
        }

        @Override
        public Icon getIcon(@Iconable.IconFlags int flags) {
            return AllIcons.Actions.IntentionBulb;
        }
    }
}

