/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore;

import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryProperties
extends LibraryProperties<State> {
    public static final String SOURCE_FILES_URLS_ELEMENT = "sourceFilesUrls";
    public static final String SOURCE_URL_ELEMENT = "item";
    public static final String SOURCE_URL_ATTR = "url";
    @Nullable
    private ScriptingFrameworkDescriptor myFramework;
    private Collection<String> mySourceFilesUrls = new ArrayList<String>();

    public ScriptingLibraryProperties() {
    }

    public ScriptingLibraryProperties(@Nullable ScriptingFrameworkDescriptor frameworkDescriptor, Collection<String> sourceFilesUrls) {
        this.myFramework = frameworkDescriptor;
        this.mySourceFilesUrls = sourceFilesUrls;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ScriptingLibraryProperties && Comparing.equal((Object)this.getFrameworkType(), (Object)((ScriptingLibraryProperties)obj).getFrameworkType()) && Comparing.haveEqualElements(this.mySourceFilesUrls, ((ScriptingLibraryProperties)obj).mySourceFilesUrls);
    }

    @Override
    public int hashCode() {
        return this.myFramework != null ? this.myFramework.hashCode() : 0;
    }

    @Override
    public State getState() {
        State state = new State();
        state.frameworkName = this.myFramework != null ? this.myFramework.getFrameworkName() : null;
        state.frameworkVersion = this.myFramework != null ? this.myFramework.getFrameworkVersion() : null;
        state.sourceFilesUrls = this.mySourceFilesUrls;
        return state;
    }

    @Override
    public void loadState(State state) {
        if (state.frameworkName != null) {
            this.myFramework = new ScriptingFrameworkDescriptor(state.frameworkName, state.frameworkVersion);
        }
        this.mySourceFilesUrls = state.sourceFilesUrls;
    }

    @Nullable
    public ScriptingFrameworkDescriptor getFrameworkType() {
        return this.myFramework;
    }

    @NotNull
    public Collection<String> getSourceFilesUrls() {
        Collection<String> collection = this.mySourceFilesUrls;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/ScriptingLibraryProperties", "getSourceFilesUrls"));
        }
        return collection;
    }

    public void setSourceFilesUrls(@NotNull Collection<String> sourceFilesUrls) {
        if (sourceFilesUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SOURCE_FILES_URLS_ELEMENT, "com/intellij/webcore/ScriptingLibraryProperties", "setSourceFilesUrls"));
        }
        this.mySourceFilesUrls = sourceFilesUrls;
    }

    public static class State {
        public String frameworkName;
        public String frameworkVersion;
        @Tag(value="sourceFilesUrls")
        @AbstractCollection(surroundWithTag=false, elementTag="item", elementValueAttribute="url")
        public Collection<String> sourceFilesUrls = new ArrayList<String>();
    }
}

