/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.ScriptingLibraryProperties;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryTable {
    private final Map<String, ScriptingLibraryModel> myLibraryModels;
    private final Map<String, ScriptingLibraryModel> myAliases;
    private final Map<String, VirtualFile> myFileNameCache;
    private final LibraryKind myLibraryKind;
    private final Project myProject;
    private volatile FileStateFinder myFileStateFinder;
    private final Object myFileStateFinderLock;

    public ScriptingLibraryTable(@NotNull LibraryKind libraryKind, @NotNull Project project) {
        if (libraryKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryKind", "com/intellij/webcore/libraries/ScriptingLibraryTable", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ScriptingLibraryTable", "<init>"));
        }
        this.myLibraryModels = new ConcurrentHashMap<String, ScriptingLibraryModel>();
        this.myAliases = new ConcurrentHashMap<String, ScriptingLibraryModel>();
        this.myFileNameCache = new ConcurrentHashMap<String, VirtualFile>();
        this.myFileStateFinderLock = new Object();
        this.myLibraryKind = libraryKind;
        this.myProject = project;
    }

    public void readFrom(@NotNull LibraryTable libraryTable) {
        if (libraryTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryTable", "com/intellij/webcore/libraries/ScriptingLibraryTable", "readFrom"));
        }
        ScriptingLibraryModel.LibraryLevel level = ScriptingLibraryManager.getLibraryLevel(libraryTable);
        for (Library library : libraryTable.getLibraries()) {
            if (!(library instanceof LibraryEx)) continue;
            this.readLibrary((LibraryEx)library, level);
        }
    }

    private void readLibrary(@NotNull LibraryEx library, @NotNull ScriptingLibraryModel.LibraryLevel level) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/libraries/ScriptingLibraryTable", "readLibrary"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/webcore/libraries/ScriptingLibraryTable", "readLibrary"));
        }
        PersistentLibraryKind<?> libType = library.getKind();
        if (libType != null && libType == this.myLibraryKind) {
            ScriptingLibraryModel libModel = new ScriptingLibraryModel(library.getName(), level);
            libModel.setOriginalLibrary(library);
            HashSet<VirtualFile> sourceFiles = new HashSet<VirtualFile>();
            HashSet<VirtualFile> compactFiles = new HashSet<VirtualFile>();
            LibraryProperties properties = library.getProperties();
            if (properties instanceof ScriptingLibraryProperties) {
                VirtualFile[] libClasses;
                ScriptingLibraryProperties libraryProperties = (ScriptingLibraryProperties)properties;
                libModel.setFrameworkDescriptor(libraryProperties.getFrameworkType());
                Collection<String> sourceFilesUrls = libraryProperties.getSourceFilesUrls();
                for (VirtualFile virtualFile : libClasses = library.getFiles(OrderRootType.CLASSES)) {
                    if (sourceFilesUrls.contains(virtualFile.getUrl())) {
                        sourceFiles.add(virtualFile);
                        continue;
                    }
                    compactFiles.add(virtualFile);
                }
                Object[] libSources = library.getFiles(OrderRootType.SOURCES);
                if (libSources.length > 0) {
                    ContainerUtil.addAll(sourceFiles, (Object[])libSources);
                    LinkedHashSet<String> sourceFilesUrlSet = new LinkedHashSet<String>(sourceFilesUrls);
                    for (Object source : libSources) {
                        sourceFilesUrlSet.add(((VirtualFile)source).getUrl());
                    }
                    libraryProperties.setSourceFilesUrls(sourceFilesUrlSet);
                }
            } else {
                compactFiles.addAll(Arrays.asList(library.getFiles(OrderRootType.CLASSES)));
            }
            libModel.setSourceFiles(sourceFiles.toArray(new VirtualFile[sourceFiles.size()]));
            libModel.setCompactFiles(compactFiles.toArray(new VirtualFile[compactFiles.size()]));
            libModel.setDocUrls(library.getUrls(OrderRootType.DOCUMENTATION));
            libModel.setAssociatedModules(ModuleHelper.getAssociatedModules(this.myProject, library));
            this.myLibraryModels.put(library.getName(), libModel);
        }
    }

    @NotNull
    public Set<String> getDocUrlsFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ScriptingLibraryTable", "getDocUrlsFor"));
        }
        THashSet urls = Collections.emptySet();
        for (ScriptingLibraryModel scriptingLibraryModel : this.myLibraryModels.values()) {
            if (!scriptingLibraryModel.containsFile(file)) continue;
            if (urls.isEmpty()) {
                urls = new THashSet();
            }
            urls.addAll(scriptingLibraryModel.getDocUrls());
        }
        THashSet tHashSet = urls;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryTable", "getDocUrlsFor"));
        }
        return tHashSet;
    }

    @Nullable
    public ScriptingLibraryModel findLibrary(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ScriptingLibraryTable", "findLibrary"));
        }
        for (ScriptingLibraryModel scriptingLibraryModel : this.myLibraryModels.values()) {
            if (!scriptingLibraryModel.containsFile(file)) continue;
            return scriptingLibraryModel;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ThreeState getFileState(VirtualFile file) {
        FileStateFinder finder = this.myFileStateFinder;
        if (finder == null) {
            Object object = this.myFileStateFinderLock;
            synchronized (object) {
                finder = this.myFileStateFinder;
                if (finder == null) {
                    this.myFileStateFinder = finder = new FileStateFinder(this.myLibraryModels.values());
                }
            }
        }
        ThreeState threeState = finder.getFileState(file);
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryTable", "getFileState"));
        }
        return threeState;
    }

    @Nullable
    public VirtualFile getMatchingFile(String fileName) {
        if (this.myFileNameCache.containsKey(fileName)) {
            return this.myFileNameCache.get(fileName);
        }
        for (ScriptingLibraryModel libModel : this.myLibraryModels.values()) {
            VirtualFile file = libModel.getMatchingFile(fileName);
            if (file == null) continue;
            this.myFileNameCache.put(fileName, file);
            return file;
        }
        return null;
    }

    public void invalidateCache() {
        this.myFileStateFinder = null;
        this.myFileNameCache.clear();
    }

    @Nullable
    public ScriptingLibraryModel getLibraryByName(@NotNull String libName) {
        if (libName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libName", "com/intellij/webcore/libraries/ScriptingLibraryTable", "getLibraryByName"));
        }
        ScriptingLibraryModel model = this.myLibraryModels.get(libName);
        if (model != null) {
            return model;
        }
        return this.myAliases.get(libName);
    }

    public void removeLibrary(ScriptingLibraryModel scriptingLibraryModel) {
        this.myLibraryModels.remove(scriptingLibraryModel.getName());
        this.invalidateCache();
    }

    @NotNull
    public ScriptingLibraryModel createPredefinedLibrary(String libName, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls, boolean isOnByDefault) {
        ScriptingLibraryModel scriptingLibraryModel = this.createLibrary(libName, sourceFiles, compactFiles, docUrls, ScriptingLibraryModel.LibraryLevel.PREDEFINED, isOnByDefault);
        if (scriptingLibraryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryTable", "createPredefinedLibrary"));
        }
        return scriptingLibraryModel;
    }

    @NotNull
    ScriptingLibraryModel createLibrary(String libName, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls, ScriptingLibraryModel.LibraryLevel libraryLevel, boolean isOnByDefault) {
        ScriptingLibraryModel libModel = new ScriptingLibraryModel(libName, sourceFiles, compactFiles, docUrls, libraryLevel, isOnByDefault);
        this.myLibraryModels.put(libName, libModel);
        this.invalidateCache();
        ScriptingLibraryModel scriptingLibraryModel = libModel;
        if (scriptingLibraryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryTable", "createLibrary"));
        }
        return scriptingLibraryModel;
    }

    @NotNull
    public ScriptingLibraryModel[] getLibraries(ScriptingLibraryModel.LibraryLevel libraryLevel) {
        ArrayList<ScriptingLibraryModel> result = new ArrayList<ScriptingLibraryModel>();
        for (ScriptingLibraryModel model : this.myLibraryModels.values()) {
            assert (model.getLibraryLevel() != null) : "NULL level for " + model.getName();
            if (!model.getLibraryLevel().equals((Object)libraryLevel)) continue;
            result.add(model);
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = result.toArray(new ScriptingLibraryModel[result.size()]);
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryTable", "getLibraries"));
        }
        return scriptingLibraryModelArray;
    }

    public ScriptingLibraryModel[] getAllLibraries() {
        return this.myLibraryModels.values().toArray(new ScriptingLibraryModel[this.myLibraryModels.size()]);
    }

    public void renameLibrary(String oldName, String newName) {
        ScriptingLibraryModel libraryModel = this.myLibraryModels.get(oldName);
        if (libraryModel != null) {
            this.myLibraryModels.remove(oldName);
            this.myLibraryModels.put(newName, libraryModel);
            this.myAliases.put(oldName, libraryModel);
        }
    }

    @Nullable
    public ScriptingLibraryModel getModel(@NotNull Library original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/webcore/libraries/ScriptingLibraryTable", "getModel"));
        }
        for (ScriptingLibraryModel model : this.myLibraryModels.values()) {
            if (model.getOriginalLibrary() != original) continue;
            return model;
        }
        return null;
    }

    private static class FileStateFinder {
        private final ImmutableMap<VirtualFile, Boolean> myStateByFileMap;
        private final ImmutableList<VirtualFile> mySourceDirs;

        private FileStateFinder(@NotNull Collection<ScriptingLibraryModel> models) {
            if (models == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/webcore/libraries/ScriptingLibraryTable$FileStateFinder", "<init>"));
            }
            HashMap stateByFileMap = ContainerUtil.newHashMap();
            ArrayList sourceDirs = ContainerUtil.newArrayList();
            for (ScriptingLibraryModel model : models) {
                for (VirtualFile f : model.getCompactFiles()) {
                    stateByFileMap.put(f, true);
                }
                for (VirtualFile f : model.getSourceFiles()) {
                    stateByFileMap.put(f, false);
                    if (!f.isDirectory()) continue;
                    sourceDirs.add(f);
                }
            }
            this.myStateByFileMap = ImmutableMap.copyOf((Map)stateByFileMap);
            this.mySourceDirs = ImmutableList.copyOf((Collection)sourceDirs);
        }

        @NotNull
        public ThreeState getFileState(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ScriptingLibraryTable$FileStateFinder", "getFileState"));
            }
            Boolean flag = (Boolean)this.myStateByFileMap.get((Object)file);
            if (flag != null) {
                ThreeState threeState = flag != false ? ThreeState.YES : ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryTable$FileStateFinder", "getFileState"));
                }
                return threeState;
            }
            if (!this.mySourceDirs.isEmpty()) {
                for (VirtualFile directory : this.mySourceDirs) {
                    if (!VfsUtilCore.isAncestor(directory, file, true)) continue;
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryTable$FileStateFinder", "getFileState"));
                    }
                    return threeState;
                }
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryTable$FileStateFinder", "getFileState"));
            }
            return threeState;
        }
    }
}

