/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DasObject {
    @NotNull
    public ObjectKind getKind();

    @NotNull
    public String getName();

    @Nullable
    public String getComment();

    @Nullable
    public DasObject getDbParent();

    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> var1, @NotNull ObjectKind var2);

    public static abstract class Adapter
    implements DasObject {
        @Override
        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DasObject$Adapter", "getName"));
            }
            return string;
        }

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public DasObject getDbParent() {
            return null;
        }

        @Override
        @NotNull
        public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/model/DasObject$Adapter", "getDbChildren"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/DasObject$Adapter", "getDbChildren"));
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DasObject$Adapter", "getDbChildren"));
            }
            return jBIterable;
        }
    }
}

