/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectsUtil {
    private static final Map<String, SqlLanguageDialect> ourDialectMap;
    public static final SqlLanguageDialect GENERIC;

    private SqlDialectsUtil() {
    }

    @NotNull
    public static Collection<SqlLanguageDialect> getSqlDialects() {
        Collection<SqlLanguageDialect> collection = ourDialectMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlDialectsUtil", "getSqlDialects"));
        }
        return collection;
    }

    @NotNull
    public static List<SqlLanguageDialect> getTopLevelSqlDialects() {
        ArrayList result = ContainerUtil.newArrayList(SqlDialectsUtil.getSqlDialects());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof InjectableLanguage)) continue;
            it.remove();
        }
        Collections.sort(result, LanguageUtil.LANGUAGE_COMPARATOR);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlDialectsUtil", "getTopLevelSqlDialects"));
        }
        return arrayList;
    }

    @Nullable
    public static SqlLanguageDialect findById(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/psi/SqlDialectsUtil", "findById"));
        }
        return ourDialectMap.get(id);
    }

    static {
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        for (Language language : SqlLanguage.INSTANCE.getDialects()) {
            if (!(language instanceof SqlLanguageDialect)) continue;
            map.put(language.getID(), (SqlLanguageDialect)language);
        }
        ourDialectMap = Collections.unmodifiableMap(map);
        GENERIC = SqlDialectsUtil.findById("GenericSQL");
        if (GENERIC == null) {
            throw new AssertionError((Object)"<Generic> SQL dialect not found");
        }
    }
}

