/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts.spring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.thymeleaf.references.paths.ThymeleafTemplateResolverMethodsSearchHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ThymeleafViewResolverFactory
extends ViewResolverFactory {
    private static final String[] ourResolvers = new String[]{"org.thymeleaf.spring3.view.ThymeleafViewResolver", "org.thymeleaf.spring4.view.ThymeleafViewResolver"};
    private static final String VIEW_RESOLVER_ID = "thymeleaf";

    protected boolean isMine(CommonSpringBean bean, PsiClass beanClass) {
        for (String resolverClass : ourResolvers) {
            if (!InheritanceUtil.isInheritor((PsiClass)beanClass, (String)resolverClass)) continue;
            return true;
        }
        return false;
    }

    public String getBeanClass() {
        return null;
    }

    public Set<ViewResolver> doCreate(CommonSpringBean bean, SpringModel model) {
        Module module;
        Module module2 = module = model.getModule() != null ? model.getModule() : bean.getModule();
        if (module == null) {
            return Collections.emptySet();
        }
        com.intellij.util.containers.hash.HashSet resolvers = new com.intellij.util.containers.hash.HashSet();
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
        PsiClass templateResolverClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.thymeleaf.templateresolver.ITemplateResolver", moduleScope);
        if (templateResolverClass == null) {
            return Collections.emptySet();
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)templateResolverClass).withInheritors();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (!configurers.isEmpty()) {
            if (bean instanceof SpringBean) {
                resolvers.addAll(this.getTemplateResolvers((SpringBean)bean));
            } else if (configurers.size() > 0) {
                for (SpringBeanPointer templateResolver : configurers) {
                    UrlBasedViewResolver viewResolver = new UrlBasedViewResolver(templateResolver.getSpringBean());
                    viewResolver.setID(VIEW_RESOLVER_ID);
                    resolvers.add(viewResolver);
                }
            }
        } else {
            PsiFile file = bean.getContainingFile();
            if (file instanceof PsiJavaFile) {
                GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)file);
                resolvers.addAll(ThymeleafViewResolverFactory.getConfiguredViewResolvers("org.thymeleaf.templateresolver.TemplateResolver", module, (SearchScope)scope));
                resolvers.addAll(ThymeleafViewResolverFactory.getConfiguredViewResolvers("org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver", module, (SearchScope)scope));
            }
        }
        return resolvers;
    }

    @NotNull
    private static Set<ViewResolver> getConfiguredViewResolvers(@NotNull String resolverClass, @NotNull Module module, @NotNull SearchScope scope) {
        if (resolverClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverClass", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getConfiguredViewResolvers"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getConfiguredViewResolvers"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getConfiguredViewResolvers"));
        }
        HashSet resolvers = ContainerUtil.newHashSet();
        PsiClass aClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(resolverClass, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        for (Pair<PsiElement, String> pair : ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixExpressions(aClass, "setPrefix", scope)) {
            String prefix = (String)pair.second;
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)pair.getFirst()), PsiMethod.class);
            if (psiMethod == null) continue;
            Set<String> suffixes = ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixes(aClass, "setSuffix", (SearchScope)new LocalSearchScope((PsiElement)psiMethod));
            if (suffixes.isEmpty()) {
                UrlBasedViewResolver viewResolver = new UrlBasedViewResolver(prefix, "");
                viewResolver.setID(VIEW_RESOLVER_ID);
                resolvers.add(viewResolver);
                continue;
            }
            resolvers.addAll(suffixes.stream().map(suffix -> {
                UrlBasedViewResolver viewResolver = new UrlBasedViewResolver(prefix, suffix);
                viewResolver.setID(VIEW_RESOLVER_ID);
                return viewResolver;
            }).collect(Collectors.toList()));
        }
        HashSet hashSet = resolvers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getConfiguredViewResolvers"));
        }
        return hashSet;
    }

    @NotNull
    public Set<ViewResolver> getTemplateResolvers(@NotNull SpringBean bean) {
        CommonSpringBean templateEngine;
        SpringBeanPointer templateEngineBean;
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getTemplateResolvers"));
        }
        com.intellij.util.containers.hash.HashSet resolvers = new com.intellij.util.containers.hash.HashSet();
        SpringPropertyDefinition property = bean.getProperty("templateEngine");
        if (property instanceof SpringProperty && (templateEngineBean = (SpringBeanPointer)((SpringProperty)property).getRefAttr().getValue()) != null && (templateEngine = templateEngineBean.getSpringBean()) instanceof SpringBean) {
            SpringPropertyDefinition templateResolversProperty;
            SpringBeanPointer templateResolver2;
            SpringPropertyDefinition templateResolverProperty = ((SpringBean)templateEngine).getProperty("templateResolver");
            if (templateResolverProperty instanceof SpringProperty && (templateResolver2 = templateResolverProperty.getRefValue()) != null) {
                UrlBasedViewResolver viewResolver = new UrlBasedViewResolver(templateResolver2.getSpringBean());
                viewResolver.setID(VIEW_RESOLVER_ID);
                resolvers.add(viewResolver);
            }
            if ((templateResolversProperty = ((SpringBean)templateEngine).getProperty("templateResolvers")) instanceof SpringProperty) {
                Set<SpringBeanPointer> pointers = ThymeleafViewResolverFactory.getCollectionPointers((SpringProperty)templateResolversProperty);
                resolvers.addAll(pointers.stream().map(templateResolver -> {
                    UrlBasedViewResolver viewResolver = new UrlBasedViewResolver(templateResolver.getSpringBean());
                    viewResolver.setID(VIEW_RESOLVER_ID);
                    return viewResolver;
                }).collect(Collectors.toList()));
            }
        }
        com.intellij.util.containers.hash.HashSet hashSet = resolvers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getTemplateResolvers"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<SpringBeanPointer> getCollectionPointers(@NotNull SpringProperty springProperty) {
        if (springProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springProperty", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getCollectionPointers"));
        }
        LinkedHashMap beans = new LinkedHashMap();
        List listOrSets = DomUtil.getChildrenOfType((DomElement)springProperty, ListOrSet.class);
        for (ListOrSet listOrSet : listOrSets) {
            SpringPropertyUtils.addCollectionReferences((CollectionElements)listOrSet, beans);
        }
        Set<SpringBeanPointer> set = beans.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getCollectionPointers"));
        }
        return set;
    }
}

