/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.references;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.xml.XmlComment;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ThymeleafXmlCommentReferenceContributor
extends PsiReferenceContributor {
    public static final PsiElementPattern.Capture<XmlComment> THYMES_VAR_COMMENT = (PsiElementPattern.Capture)PlatformPatterns.psiElement(XmlComment.class).withText((ElementPattern)StandardPatterns.string().contains("@thymesVar"));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/thymeleaf/references/ThymeleafXmlCommentReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(THYMES_VAR_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/thymeleaf/references/ThymeleafXmlCommentReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/references/ThymeleafXmlCommentReferenceContributor$1", "getReferencesByElement"));
                }
                String text = element.getText();
                int start = ThymeleafXmlCommentReferenceContributor.getTypeStartOffset(text);
                if (start < 0) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/ThymeleafXmlCommentReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                int end = ThymeleafXmlCommentReferenceContributor.getTypeEndOffset(text);
                if (end < 0) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/ThymeleafXmlCommentReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new JavaClassReferenceProvider().getReferencesByString(text.substring(start, end), element, start);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/ThymeleafXmlCommentReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    public static int getTypeStartOffset(String text) {
        return ThymeleafXmlCommentReferenceContributor.getAttributeStartOffset("type", text);
    }

    private static int getAttributeStartOffset(@NonNls String attrName, String text) {
        String str = attrName + "=\"";
        int start = text.indexOf(str);
        if (start >= 0) {
            start += str.length();
        }
        return start;
    }

    public static int getTypeEndOffset(String text) {
        return ThymeleafXmlCommentReferenceContributor.getAttributeEndOffset("type", text);
    }

    private static int getAttributeEndOffset(@NonNls String attrName, String text) {
        int start = ThymeleafXmlCommentReferenceContributor.getAttributeStartOffset(attrName, text);
        return text.indexOf("\"", start);
    }
}

