/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.descriptor;

import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.lang.descriptor.DescriptorUtil;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryNamespaceDescriptor;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.psi.TmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.dtd.XmlNSDescriptorImpl;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryXmlExtension
extends DefaultXmlExtension {
    private static final Set<String> ourTapestryTemplateNamespaces = new THashSet(Arrays.asList("http://tapestry.apache.org/schema/tapestry_5_1_0.xsd", "http://tapestry.apache.org/schema/tapestry_5_0_0.xsd", "http://tapestry.apache.org/schema/tapestry_5_3.xsd", "http://tapestry.apache.org/schema/tapestry_5_4.xsd"));

    public static boolean isTapestryTemplateNamespace(String namespace) {
        return namespace != null && ourTapestryTemplateNamespaces.contains(namespace);
    }

    @NotNull
    public static String getTapestryNamespace(XmlTag tag) {
        if (tag != null) {
            for (String tapestryTemplateNamespace : ourTapestryTemplateNamespaces) {
                if (tag.getPrefixByNamespace(tapestryTemplateNamespace) == null) continue;
                String string = tapestryTemplateNamespace;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/descriptor/TapestryXmlExtension", "getTapestryNamespace"));
                }
                return string;
            }
        }
        if ("http://tapestry.apache.org/schema/tapestry_5_1_0.xsd" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/descriptor/TapestryXmlExtension", "getTapestryNamespace"));
        }
        return "http://tapestry.apache.org/schema/tapestry_5_1_0.xsd";
    }

    @Nullable
    public static TapestryNamespaceDescriptor getTapestryTemplateDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/tapestry/intellij/lang/descriptor/TapestryXmlExtension", "getTapestryTemplateDescriptor"));
        }
        XmlNSDescriptor rootTagNSDescriptor = tag.getNSDescriptor(TapestryXmlExtension.getTapestryNamespace(tag), true);
        return rootTagNSDescriptor instanceof TapestryNamespaceDescriptor ? (TapestryNamespaceDescriptor)rootTagNSDescriptor : null;
    }

    @Nullable
    public String[][] getNamespacesFromDocument(XmlDocument parent, boolean declarationsExist) {
        String[][] namespaces = new String[][]{{"", "http://www.w3.org/1999/xhtml"}, {"t", "http://tapestry.apache.org/schema/tapestry_5_1_0.xsd"}, {"p", "tapestry:parameter"}};
        XmlTag rootTag = parent.getRootTag();
        if (rootTag == null) {
            return namespaces;
        }
        for (XmlAttribute attribute : rootTag.getAttributes()) {
            if (!attribute.isNamespaceDeclaration()) continue;
            String attributeValue = attribute.getValue();
            if ("tapestry:parameter".equals(attributeValue)) {
                namespaces[2][0] = TapestryXmlExtension.getNamespacePrefixFromDeclaration(attribute);
                continue;
            }
            if (TapestryXmlExtension.isTapestryTemplateNamespace(attributeValue)) {
                namespaces[1][0] = TapestryXmlExtension.getNamespacePrefixFromDeclaration(attribute);
                namespaces[1][1] = attributeValue;
                continue;
            }
            if (!"http://www.w3.org/1999/xhtml".equals(attributeValue)) continue;
            namespaces[0][0] = TapestryXmlExtension.getNamespacePrefixFromDeclaration(attribute);
        }
        return namespaces;
    }

    private static String getNamespacePrefixFromDeclaration(XmlAttribute attribute) {
        String localName = attribute.getLocalName();
        return localName.equals(attribute.getName()) ? "" : localName;
    }

    public boolean isAvailable(PsiFile file) {
        return file instanceof TmlFile;
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        TapestryProject tapestryProject = TapestryModuleSupportLoader.getTapestryProject((XmlElement)tag);
        if (tapestryProject == null) {
            return super.isRequiredAttributeImplicitlyPresent(tag, attrName);
        }
        if (tag.getAttribute(attrName, TapestryXmlExtension.getTapestryNamespace(tag)) != null) {
            return true;
        }
        PresentationLibraryElement element = tapestryProject.findElementByTemplate(tag.getContainingFile());
        return element != null && TapestryUtils.parameterDefinedInClass(attrName, (IntellijJavaClassType)element.getElementClass(), tag);
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        PsiFile file = element.getContainingFile();
        if (!(file instanceof TmlFile)) {
            return null;
        }
        return element.getNSDescriptor(namespace, strict);
    }

    public XmlNSDescriptor getDescriptorFromDoctype(XmlFile file, XmlNSDescriptor descriptor) {
        XmlDocument doc;
        if (file instanceof TmlFile && descriptor instanceof XmlNSDescriptorImpl && (doc = file.getDocument()) != null && doc.getProlog().getDoctype() != null) {
            return DescriptorUtil.getHtmlNSDescriptor((TmlFile)file);
        }
        return descriptor;
    }

    public static String[] tapestryTemplateNamespaces() {
        return ArrayUtil.toStringArray(ourTapestryTemplateNamespaces);
    }
}

