/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.openapi.project.Project;
import gnu.trove.TIntObjectHashMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesPresentationCache {
    private static final Map<DupInfo, TIntObjectHashMap<DuplicatesPresentation>> ourPresentationCache = new HashMap<DupInfo, TIntObjectHashMap<DuplicatesPresentation>>();
    private static final DuplicatesPresentation NULL_PRESENTATION = new DuplicatesPresentation(){

        @Override
        public boolean isFixAbilityProvided() {
            return false;
        }

        @Override
        public boolean isFixAvailable(@NotNull CodeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/DuplicatesPresentationCache$1", "isFixAvailable"));
            }
            return false;
        }

        @Override
        public void applyFix(@NotNull CodeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/DuplicatesPresentationCache$1", "applyFix"));
            }
        }

        @Override
        @NotNull
        public DuplicatesProfile getProfile() {
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesPresentationCache$1", "getProfile"));
            }
            return null;
        }

        @Override
        @Nullable
        public CodeFragmentType getType(@NotNull CodeNode node) throws InvalidatedException {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/DuplicatesPresentationCache$1", "getType"));
            }
            return null;
        }

        @Override
        @NotNull
        public DuplicatesView createView(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/DuplicatesPresentationCache$1", "createView"));
            }
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesPresentationCache$1", "createView"));
            }
            return null;
        }

        @Override
        @NotNull
        public DuplocatorSettingsEditor createEditor(@NotNull DuplocatorState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/dupLocator/DuplicatesPresentationCache$1", "createEditor"));
            }
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesPresentationCache$1", "createEditor"));
            }
            return null;
        }
    };

    private DuplicatesPresentationCache() {
    }

    public static void clear(@NotNull DupInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/dupLocator/DuplicatesPresentationCache", "clear"));
        }
        ourPresentationCache.remove(info);
    }

    @Nullable
    public static DuplicatesPresentation getPresentation(@NotNull DupInfo dupInfo, int index) {
        DuplicatesPresentation result;
        if (dupInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dupInfo", "com/intellij/dupLocator/DuplicatesPresentationCache", "getPresentation"));
        }
        TIntObjectHashMap patternCache = ourPresentationCache.get(dupInfo);
        if (patternCache == null) {
            patternCache = new TIntObjectHashMap();
            ourPresentationCache.put(dupInfo, (TIntObjectHashMap<DuplicatesPresentation>)patternCache);
        }
        if ((result = (DuplicatesPresentation)patternCache.get(index)) == null) {
            DuplicatesPresentation[] presentations = DuplicatesPresentation.Service.getAllPresentations();
            DuplicatesPresentation thePresentation = null;
            for (DuplicatesPresentation presentation : presentations) {
                if (!presentation.getProfile().isMyDuplicate(dupInfo, index)) continue;
                thePresentation = presentation;
                break;
            }
            result = thePresentation == null ? NULL_PRESENTATION : thePresentation;
            patternCache.put(index, (Object)result);
        }
        return result == NULL_PRESENTATION ? null : result;
    }
}

