/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public abstract class AopAdvisedElementsSearcher {
    private final PsiManager myManager;

    protected AopAdvisedElementsSearcher(PsiManager manager) {
        this.myManager = manager;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public abstract LinkedHashSet<PsiClass> collectAdvisedClasses();

    public boolean shouldSuppressErrors() {
        return false;
    }

    public boolean canBeAdvised(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/aop/AopAdvisedElementsSearcher", "canBeAdvised"));
        }
        return !method.isConstructor() && !method.hasModifierProperty("abstract");
    }

    public boolean acceptsBoundMethodHeavy(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/aop/AopAdvisedElementsSearcher", "acceptsBoundMethodHeavy"));
        }
        return true;
    }

    public boolean isInherentlyAdvisable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/aop/AopAdvisedElementsSearcher", "isInherentlyAdvisable"));
        }
        return AopAdvisedElementsSearcher.isAspectjAdvisable(psiClass);
    }

    public boolean isAdvisableInModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/aop/AopAdvisedElementsSearcher", "isAdvisableInModel"));
        }
        return false;
    }

    protected static boolean isAspectjAdvisable(PsiClass psiClass) {
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return false;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        return modifierList == null || modifierList.findAnnotation("org.aspectj.lang.annotation.Aspect") == null;
    }
}

