/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.lexer;

import com.intellij.aop.lexer._AopLexer;
import com.intellij.aop.psi.AopElementType;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopPointcutTypes;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AopLexer
extends LookAheadLexer
implements AopElementTypes {
    @NonNls
    public static final Map<String, AopElementType> PRIMITIVE_TYPES = new THashMap();
    @NonNls
    public static final Map<String, AopElementType> LOGICAL_OP_TYPES = new THashMap();

    public AopLexer() {
        super((Lexer)new FlexAdapter((FlexLexer)new _AopLexer()));
    }

    protected void lookAhead(Lexer baseLexer) {
        this.topLevel(baseLexer);
    }

    private void topLevel(Lexer baseLexer) {
        if (this.logicalOperation(baseLexer)) {
            return;
        }
        IElementType pointcutFirst = this.pointcutDesignator(baseLexer);
        if (pointcutFirst != null) {
            Map<String, AopElementType> pointcutTokens = AopPointcutTypes.getPointcutTokens();
            boolean recursive = pointcutFirst == pointcutTokens.get("cflow") || pointcutFirst == pointcutTokens.get("cflowbelow");
            this.whitespace(baseLexer);
            if (baseLexer.getTokenType() == AOP_LEFT_PAR) {
                this.advanceLexer(baseLexer);
                int count = 1;
                while (count > 0) {
                    IElementType type = baseLexer.getTokenType();
                    if (type == AOP_LEFT_PAR) {
                        ++count;
                    }
                    if (type == AOP_RIGHT_PAR) {
                        --count;
                    }
                    if (recursive) {
                        this.topLevel(baseLexer);
                    } else {
                        this.handlePrimitiveTypes(baseLexer, type);
                    }
                    if (type != null) continue;
                    break;
                }
            }
        }
    }

    private void whitespace(Lexer baseLexer) {
        while (baseLexer.getTokenType() == WHITE_SPACE) {
            this.advanceLexer(baseLexer);
        }
    }

    private void handlePrimitiveTypes(Lexer baseLexer, IElementType type) {
        AopElementType primitive;
        if (AOP_IDENTIFIER == type && (primitive = PRIMITIVE_TYPES.get(baseLexer.getTokenText())) != null && !AopLexer.dotFollows(baseLexer)) {
            this.advanceAs(baseLexer, primitive);
            return;
        }
        if (!this.logicalOperation(baseLexer)) {
            this.advanceLexer(baseLexer);
        }
    }

    private boolean logicalOperation(Lexer baseLexer) {
        AopElementType op;
        if (((Object)((Object)AOP_IDENTIFIER)).equals(baseLexer.getTokenType()) && (op = LOGICAL_OP_TYPES.get(baseLexer.getTokenText())) != null) {
            this.advanceAs(baseLexer, op);
            return true;
        }
        return false;
    }

    @Nullable
    private IElementType pointcutDesignator(Lexer baseLexer) {
        IElementType tokenType = baseLexer.getTokenType();
        if (AOP_AT == tokenType) {
            AopElementType pointcutType;
            baseLexer.advance();
            if (AOP_IDENTIFIER == baseLexer.getTokenType() && (pointcutType = AopPointcutTypes.getPointcutTokens().get("@" + baseLexer.getTokenText())) != null) {
                this.advanceAs(baseLexer, pointcutType);
                return pointcutType;
            }
            this.addToken(baseLexer.getTokenStart(), AOP_AT);
            this.advanceLexer(baseLexer);
            return null;
        }
        if (AOP_IDENTIFIER == tokenType) {
            AopElementType pointcutType = AopPointcutTypes.getPointcutTokens().get(baseLexer.getTokenText());
            IElementType first = pointcutType != null && !AopLexer.dotFollows(baseLexer) ? pointcutType : tokenType;
            this.advanceAs(baseLexer, first);
            this.whitespace(baseLexer);
            while (baseLexer.getTokenType() == AOP_DOT) {
                this.advanceLexer(baseLexer);
                this.whitespace(baseLexer);
                if (((Object)((Object)AOP_IDENTIFIER)).equals(baseLexer.getTokenType())) {
                    this.advanceLexer(baseLexer);
                    this.whitespace(baseLexer);
                    continue;
                }
                return null;
            }
            return first;
        }
        this.advanceLexer(baseLexer);
        return null;
    }

    private static boolean dotFollows(Lexer baseLexer) {
        LexerPosition position = baseLexer.getCurrentPosition();
        baseLexer.advance();
        try {
            while (baseLexer.getTokenType() == WHITE_SPACE) {
                baseLexer.advance();
            }
            if (baseLexer.getTokenType() == AOP_DOT) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            baseLexer.restore(position);
        }
        return false;
    }

    static {
        PRIMITIVE_TYPES.put("int", AOP_INT);
        PRIMITIVE_TYPES.put("char", AOP_CHAR);
        PRIMITIVE_TYPES.put("byte", AOP_BYTE);
        PRIMITIVE_TYPES.put("short", AOP_SHORT);
        PRIMITIVE_TYPES.put("long", AOP_LONG);
        PRIMITIVE_TYPES.put("double", AOP_DOUBLE);
        PRIMITIVE_TYPES.put("float", AOP_FLOAT);
        PRIMITIVE_TYPES.put("boolean", AOP_BOOLEAN);
        PRIMITIVE_TYPES.put("void", AOP_VOID);
        LOGICAL_OP_TYPES.put("and", AOP_AND);
        LOGICAL_OP_TYPES.put("or", AOP_OR);
        LOGICAL_OP_TYPES.put("not", AOP_NOT);
    }
}

