/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.util.Processor;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PsiClassTypePattern
extends AopPsiTypePattern {
    private final String myText;
    private final Pattern myPattern;

    public PsiClassTypePattern(String pattern) {
        assert (!"*".equals(pattern));
        this.myText = pattern;
        String regex = "*".equals(pattern) ? ".*" : pattern.replaceAll("([\\[\\]\\^\\(\\)\\{\\}\\-])", "\\\\$1").replaceAll("\\*", "\\[\\^\\\\.]\\*").replaceAll("\\.", "\\\\.").replaceAll("\\\\.\\\\.", "\\(\\\\.\\|\\\\.\\.\\*\\\\.\\)");
        this.myPattern = Pattern.compile(regex);
    }

    public String getText() {
        return this.myText;
    }

    public String toString() {
        return "PsiClassTypePattern:" + this.myText;
    }

    @Override
    public boolean accepts(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/aop/psi/PsiClassTypePattern", "accepts"));
        }
        return this.myPattern.matcher(qualifiedName).matches();
    }

    @Override
    public boolean processPackages(PsiManager manager, Processor<PsiPackage> processor) {
        int asterisk = this.myText.indexOf(42);
        if (asterisk < 0) {
            asterisk = Integer.MAX_VALUE;
        }
        int i = 0;
        while (true) {
            String prefix = this.myText.substring(0, i);
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(prefix);
            if (psiPackage == null) {
                return true;
            }
            int i1 = this.myText.indexOf(46, i + 1);
            if (i1 == i + 1) {
                return PsiClassTypePattern.processSubPackages(psiPackage, processor);
            }
            if (!processor.process((Object)psiPackage)) {
                return false;
            }
            if (i1 > asterisk) {
                return true;
            }
            if (i == this.myText.length()) {
                return true;
            }
            i = i1 < 0 ? this.myText.length() : i1;
        }
    }

    @Override
    public boolean accepts(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/PsiClassTypePattern", "accepts"));
        }
        if (type instanceof PsiClassType) {
            String qname = type.getCanonicalText();
            int generics = qname.indexOf(60);
            if (generics > 0) {
                qname = qname.substring(0, generics);
            }
            if (qname != null && this.accepts(qname)) {
                return true;
            }
        }
        return false;
    }
}

