/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateManager;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.DuplocatorSettingsDialog;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DuplocateAction
extends BaseAnalysisAction {
    public DuplocateAction() {
        super(DupLocatorBundle.message((String)"duplication.title", (Object[])new Object[0]), DupLocatorBundle.message((String)"duplication.scope.name.prefix", (Object[])new Object[0]));
    }

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/DuplocateAction", "analyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/dupLocator/DuplocateAction", "analyze"));
        }
        DuplicatesProfile[] profiles = (DuplicatesProfile[])Extensions.getExtensions((ExtensionPointName)DuplicatesProfile.EP_NAME);
        DuplocatorSettingsDialog dialog = new DuplocatorSettingsDialog(project, profiles, scope);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            List<DuplicatesProfile> duplicatesProfileSet = dialog.getAllSelectedProfiles();
            DuplicatesProfile[] selectedProfiles = duplicatesProfileSet.toArray(new DuplicatesProfile[duplicatesProfileSet.size()]);
            DuplocatorSettings settings = DuplocatorSettings.getInstance();
            DuplocateManager.getInstance(project).findAndShow(scope, settings, selectedProfiles);
        }
    }

    protected String getHelpTopic() {
        return "reference.dialogs.locateDuplicates.scope";
    }
}

