/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.spring.contexts.model.AbstractSimpleSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentScanPackagesModel
extends AbstractSimpleSpringModel {
    private final NotNullLazyValue<Set<PsiPackage>> myPackages;
    @NotNull
    private final Module myModule;

    public ComponentScanPackagesModel(@NotNull NotNullLazyValue<Set<PsiPackage>> packages, @NotNull Module module) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "<init>"));
        }
        this.myPackages = packages;
        this.myModule = module;
    }

    @Override
    protected final Collection<SpringBeanPointer> calculateLocalBeans() {
        Collection<SpringBeanPointer> pointers = this.calculateScannedBeans();
        java.util.HashSet javaBeans = ContainerUtil.newHashSet();
        for (SpringBeanPointer pointer : pointers) {
            Object springBean = pointer.getSpringBean();
            if (springBean instanceof SpringConfiguration || !(springBean instanceof SpringStereotypeElement)) continue;
            javaBeans.addAll(((SpringStereotypeElement)springBean).getBeans());
        }
        java.util.HashSet beans = ContainerUtil.newHashSet();
        beans.addAll(pointers);
        beans.addAll(BeanService.getInstance().mapSpringBeans(javaBeans));
        return beans;
    }

    protected Collection<SpringBeanPointer> calculateScannedBeans() {
        return ComponentScanPackagesModel.getScannedComponents((Set)this.myPackages.getValue(), this.getModule(), this.getActiveProfiles());
    }

    public static Collection<SpringBeanPointer> getScannedComponents(@NotNull Set<PsiPackage> packages, @NotNull Module module, @Nullable Set<String> profiles) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedComponents"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedComponents"));
        }
        return ComponentScanPackagesModel.getScannedComponents(packages, module, profiles, true, Collections.emptySet(), Collections.emptySet());
    }

    public static Collection<SpringConfiguration> getScannedConfigurations(SpringBeansPackagesScan scan, @NotNull Module module, @Nullable Set<String> profiles) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedConfigurations"));
        }
        List<CommonSpringBean> components = ComponentScanPackagesModel.getScannedComponents(dom -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "lambda$getScannedConfigurations$0"));
            }
            return SpringJamModel.getModel(module).getConfigurations((GlobalSearchScope)dom);
        }, scan.getPsiPackages(), module, profiles, scan.useDefaultFilters(), scan.getExcludeContextFilters(), scan.getIncludeContextFilters());
        LinkedHashSet<SpringConfiguration> configurations = new LinkedHashSet<SpringConfiguration>();
        for (CommonSpringBean component : components) {
            if (!(component instanceof SpringConfiguration)) continue;
            configurations.add((SpringConfiguration)component);
        }
        return configurations;
    }

    public static Collection<SpringBeanPointer> getScannedComponents(@NotNull Set<PsiPackage> packages, @NotNull Module module, @Nullable Set<String> profiles, boolean useDefaultFilters, @NotNull Set<SpringContextFilter.Exclude> excludeContextFilters, @NotNull Set<SpringContextFilter.Include> includeContextFilters) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedComponents"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedComponents"));
        }
        if (excludeContextFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludeContextFilters", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedComponents"));
        }
        if (includeContextFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includeContextFilters", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedComponents"));
        }
        List<CommonSpringBean> components = ComponentScanPackagesModel.getScannedComponents(dom -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "lambda$getScannedComponents$1"));
            }
            return SpringJamModel.getModel(module).getStereotypeComponents((GlobalSearchScope)dom);
        }, packages, module, profiles, useDefaultFilters, excludeContextFilters, includeContextFilters);
        return BeanService.getInstance().mapSpringBeans(components);
    }

    public static <T extends SpringStereotypeElement> List<CommonSpringBean> getScannedComponents(@NotNull NotNullFunction<GlobalSearchScope, List<T>> components, @NotNull Set<PsiPackage> packages, @NotNull Module module, @Nullable Set<String> profiles, boolean useDefaultFilters, @NotNull Set<SpringContextFilter.Exclude> excludeContextFilters, @NotNull Set<SpringContextFilter.Include> includeContextFilters) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedComponents"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedComponents"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedComponents"));
        }
        if (excludeContextFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludeContextFilters", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedComponents"));
        }
        if (includeContextFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includeContextFilters", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getScannedComponents"));
        }
        if (module.isDisposed()) {
            return ContainerUtil.newArrayList();
        }
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        ArrayList<SpringStereotypeElement> allPointers = new ArrayList<SpringStereotypeElement>();
        HashSet notNullPackages = new HashSet();
        for (PsiPackage psiPackage : packages) {
            if (psiPackage == null) continue;
            notNullPackages.add(psiPackage);
            GlobalSearchScope searchScope = moduleScope.intersectWith(PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true));
            for (SpringStereotypeElement stereotypeElement : (List)components.fun((Object)searchScope)) {
                allPointers.add(stereotypeElement);
            }
        }
        Set<CommonSpringBean> filteredBeans = SpringJamUtils.getInstance().filterComponentScannedStereotypes(module, allPointers, (Set<PsiPackage>)notNullPackages, useDefaultFilters, excludeContextFilters, includeContextFilters);
        return SpringProfileUtils.filterBeansInActiveProfiles(filteredBeans, profiles);
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getModule"));
        }
        return module;
    }

    @Override
    @NotNull
    public Set<String> getAllProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getAllProfiles"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set<PsiFile> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "getConfigFiles"));
        }
        return set;
    }

    @Override
    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/ComponentScanPackagesModel", "hasConfigFile"));
        }
        return false;
    }
}

