/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.contextProviders;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringElContextsExtension {
    private static final ExtensionPointName<SpringElContextsExtension> EP_NAME = new ExtensionPointName("com.intellij.spring.el.contexts");

    public static SpringElContextsExtension[] getProviders() {
        return (SpringElContextsExtension[])Extensions.getExtensions(EP_NAME);
    }

    @NotNull
    public abstract Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement var1);

    @NotNull
    public Collection<PsiMethod> getRootMethods(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/spring/el/contextProviders/SpringElContextsExtension", "getRootMethods"));
        }
        List<PsiMethod> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/contextProviders/SpringElContextsExtension", "getRootMethods"));
        }
        return list;
    }

    @Nullable
    public PsiVariable findContextVariable(@NotNull PsiElement contextElement, final @NotNull String hint) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/spring/el/contextProviders/SpringElContextsExtension", "findContextVariable"));
        }
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/spring/el/contextProviders/SpringElContextsExtension", "findContextVariable"));
        }
        return (PsiVariable)ContainerUtil.find(this.getContextVariables(contextElement), (Condition)new Condition<PsiVariable>(){

            public boolean value(PsiVariable variable) {
                return hint.equals(variable.getName());
            }
        });
    }
}

