/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;

public abstract class SpringModelSearchParameters {
    protected SpringModelSearchParameters() {
    }

    public abstract boolean canSearch();

    public static BeanClass byClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/SpringModelSearchParameters", "byClass"));
        }
        return new BeanClass(psiClass);
    }

    public static BeanClass byType(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/SpringModelSearchParameters", "byType"));
        }
        return new BeanClass(psiType);
    }

    public static BeanName byName(@NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/SpringModelSearchParameters", "byName"));
        }
        return new BeanName(beanName);
    }

    public static class BeanName
    extends SpringModelSearchParameters {
        @NotNull
        private final String myBeanName;
        private final boolean myCanSearch;

        private BeanName(@NotNull String beanName) {
            if (beanName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/SpringModelSearchParameters$BeanName", "<init>"));
            }
            this.myBeanName = beanName;
            this.myCanSearch = StringUtil.isNotEmpty((String)beanName);
        }

        @Override
        public boolean canSearch() {
            return this.myCanSearch;
        }

        @NotNull
        public String getBeanName() {
            String string = this.myBeanName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringModelSearchParameters$BeanName", "getBeanName"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeanName)) {
                return false;
            }
            BeanName name = (BeanName)o;
            if (this.myCanSearch != name.myCanSearch) {
                return false;
            }
            return this.myBeanName.equals(name.myBeanName);
        }

        public int hashCode() {
            return this.myBeanName.hashCode();
        }
    }

    public static class BeanClass
    extends SpringModelSearchParameters {
        private final PsiType myType;
        private final boolean myCanSearch;
        private boolean myWithInheritors;
        private boolean myEffectiveBeanTypes;

        private BeanClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/SpringModelSearchParameters$BeanClass", "<init>"));
            }
            this.myType = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass, PsiSubstitutor.EMPTY);
            this.myCanSearch = SpringCommonUtils.isSpringBeanCandidateClass(psiClass);
        }

        private BeanClass(@NotNull PsiType psiType) {
            if (psiType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/SpringModelSearchParameters$BeanClass", "<init>"));
            }
            this.myType = psiType;
            PsiClass searchClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
            this.myCanSearch = searchClass == null || SpringCommonUtils.isSpringBeanCandidateClass(searchClass);
        }

        @Override
        public boolean canSearch() {
            return this.myCanSearch;
        }

        public BeanClass withInheritors() {
            this.myWithInheritors = true;
            return this;
        }

        @Deprecated
        public BeanClass withInheritors(GlobalSearchScope inheritorsSearchScope) {
            return this.withInheritors();
        }

        public BeanClass effectiveBeanTypes() {
            this.myEffectiveBeanTypes = true;
            return this;
        }

        @NotNull
        public PsiType getSearchType() {
            PsiType psiType = this.myType;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringModelSearchParameters$BeanClass", "getSearchType"));
            }
            return psiType;
        }

        public boolean isWithInheritors() {
            return this.myWithInheritors;
        }

        public boolean isEffectiveBeanTypes() {
            return this.myEffectiveBeanTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeanClass)) {
                return false;
            }
            BeanClass beanClass = (BeanClass)o;
            if (this.myEffectiveBeanTypes != beanClass.myEffectiveBeanTypes) {
                return false;
            }
            if (this.myWithInheritors != beanClass.myWithInheritors) {
                return false;
            }
            if (this.myCanSearch != beanClass.myCanSearch) {
                return false;
            }
            if (!this.myType.isValid() || !beanClass.getSearchType().isValid()) {
                return false;
            }
            return this.myType.equals(beanClass.getSearchType());
        }

        public int hashCode() {
            int result = this.myType.hashCode();
            result = 31 * result + (this.myWithInheritors ? 1 : 0);
            result = 31 * result + (this.myEffectiveBeanTypes ? 1 : 0);
            return result;
        }
    }
}

