/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringProfileUtils {
    @NotNull
    public static Set<String> getAllProfiles(@Nullable Beans beans) {
        LinkedHashSet names = ContainerUtil.newLinkedHashSet();
        SpringProfileUtils.processProfiles(beans, (Processor<Beans>)((Processor)nestedBeans -> {
            names.addAll(nestedBeans.getProfile().getNames());
            return true;
        }));
        LinkedHashSet linkedHashSet = names;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringProfileUtils", "getAllProfiles"));
        }
        return linkedHashSet;
    }

    public static boolean processProfiles(@Nullable Beans beans, @NotNull Processor<Beans> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/utils/SpringProfileUtils", "processProfiles"));
        }
        if (beans != null) {
            if (!processor.process((Object)beans)) {
                return false;
            }
            for (Beans childrenBeans : beans.getBeansProfiles()) {
                if (SpringProfileUtils.processProfiles(childrenBeans, processor)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isInActiveProfile(@NotNull DomElement value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/model/utils/SpringProfileUtils", "isInActiveProfile"));
        }
        Beans beans = (Beans)DomUtil.getParentOfType((DomElement)value, Beans.class, (boolean)true);
        if (beans != null) {
            CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((PsiElement)value.getXmlElement());
            return SpringProfileUtils.isActiveProfile(beans, model.getActiveProfiles());
        }
        return true;
    }

    public static boolean isInActiveProfile(@NotNull DomElement domElement, @NotNull Set<String> profiles) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/spring/model/utils/SpringProfileUtils", "isInActiveProfile"));
        }
        if (profiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profiles", "com/intellij/spring/model/utils/SpringProfileUtils", "isInActiveProfile"));
        }
        Beans beans = (Beans)DomUtil.getParentOfType((DomElement)domElement, Beans.class, (boolean)true);
        if (beans != null) {
            return SpringProfileUtils.isActiveProfile(beans, profiles);
        }
        return true;
    }

    public static boolean isActiveProfile(@Nullable Beans beans, @Nullable Set<String> activeProfiles) {
        if (beans == null) {
            return false;
        }
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            return true;
        }
        if (SpringProfileUtils.isActive(beans.getProfile().getNames(), activeProfiles)) {
            Beans parentBeans = (Beans)DomUtil.getParentOfType((DomElement)beans, Beans.class, (boolean)true);
            return parentBeans == null || SpringProfileUtils.isActiveProfile(parentBeans, activeProfiles);
        }
        if (StringUtil.isEmptyOrSpaces((String)beans.getProfile().getStringValue())) {
            Beans parentBeans = (Beans)DomUtil.getParentOfType((DomElement)beans, Beans.class, (boolean)true);
            return parentBeans == null || SpringProfileUtils.isActiveProfile(parentBeans, activeProfiles);
        }
        return false;
    }

    public static boolean isActive(@NotNull Set<String> profiles, @NotNull Set<String> activeProfiles) {
        if (profiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profiles", "com/intellij/spring/model/utils/SpringProfileUtils", "isActive"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/model/utils/SpringProfileUtils", "isActive"));
        }
        if (profiles.size() == 1 && profiles.iterator().next().equals("_DEFAULT_PROFILE_NAME_")) {
            return true;
        }
        for (String profile : profiles) {
            String notProfile;
            if (!(profile.startsWith("!") ? !activeProfiles.contains(notProfile = profile.substring(1)) : activeProfiles.contains(profile))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String profilesAsString(@Nullable Set<String> activeProfiles) {
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringProfileUtils", "profilesAsString"));
            }
            return "";
        }
        TreeSet<String> profiles = new TreeSet<String>();
        for (String activeProfile : activeProfiles) {
            if ("_DEFAULT_PROFILE_NAME_".equals(activeProfile)) continue;
            profiles.add(activeProfile);
        }
        if (profiles.size() > 1) {
            String string = StringUtil.join(profiles, (String)", ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringProfileUtils", "profilesAsString"));
            }
            return string;
        }
        String string = (String)ContainerUtil.getFirstItem(profiles, (Object)"");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringProfileUtils", "profilesAsString"));
        }
        return string;
    }

    @NotNull
    public static <T extends CommonSpringBean> List<T> filterBeansInActiveProfiles(@NotNull Collection<T> allBeans, @Nullable Set<String> activeProfiles) {
        if (allBeans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allBeans", "com/intellij/spring/model/utils/SpringProfileUtils", "filterBeansInActiveProfiles"));
        }
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            SmartList smartList = new SmartList(allBeans);
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringProfileUtils", "filterBeansInActiveProfiles"));
            }
            return smartList;
        }
        SmartList profiledStereotypes = new SmartList();
        for (CommonSpringBean stereotypeElement : allBeans) {
            SpringProfile profile;
            if (!stereotypeElement.isValid() || !SpringProfileUtils.isProfileAccepted(profile = stereotypeElement.getProfile(), activeProfiles)) continue;
            profiledStereotypes.add(stereotypeElement);
        }
        SmartList smartList = profiledStereotypes;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringProfileUtils", "filterBeansInActiveProfiles"));
        }
        return smartList;
    }

    public static boolean isProfileAccepted(@NotNull SpringProfile profile, @Nullable Set<String> activeProfiles) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/spring/model/utils/SpringProfileUtils", "isProfileAccepted"));
        }
        if (profile == SpringProfile.DEFAULT || activeProfiles == null || activeProfiles.isEmpty()) {
            return true;
        }
        return SpringProfileUtils.isActive(profile.getNames(), activeProfiles);
    }
}

