/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.comment;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSChangeToEndOfLineCommentIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        CStyleCommentPredicate cStyleCommentPredicate = new CStyleCommentPredicate();
        if (cStyleCommentPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/comment/JSChangeToEndOfLineCommentIntention", "getElementPredicate"));
        }
        return cStyleCommentPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSChangeToEndOfLineCommentIntention", "processIntention"));
        }
        PsiElement parent = element.getParent();
        assert (parent != null);
        String commentText = element.getText();
        PsiElement whitespace = element.getNextSibling();
        String text = commentText.substring(2, commentText.length() - 2);
        String[] lines = text.split("\n");
        String[] newComments = JSChangeToEndOfLineCommentIntention.buildCommentStrings(lines);
        PsiElement currentElement = element;
        int index = newComments.length;
        while (--index >= 0) {
            if (newComments[index].length() <= 0) continue;
            currentElement = JSElementFactory.addElementBefore(currentElement, "\n");
            currentElement = JSElementFactory.addElementBefore(currentElement, newComments[index]);
        }
        if (whitespace != null) {
            JSElementFactory.removeElement(whitespace);
        }
        JSElementFactory.removeElement(element);
    }

    private static String[] buildCommentStrings(String[] lines) {
        int lastNonEmtpyLine = -1;
        for (int i = lines.length - 1; i >= 0 && lastNonEmtpyLine == -1; --i) {
            String line = lines[i].trim();
            if (line.length() == 0) continue;
            lastNonEmtpyLine = i;
        }
        if (lastNonEmtpyLine == -1) {
            return new String[]{"//"};
        }
        StringBuilder buffer = new StringBuilder();
        String[] commentStrings = new String[lastNonEmtpyLine + 1];
        for (int i = 0; i <= lastNonEmtpyLine; ++i) {
            String line = lines[i];
            if (line.trim().length() != 0) {
                buffer.replace(0, buffer.length(), "//");
                if (line.startsWith(" *")) {
                    buffer.append(line.substring(2));
                } else if (line.startsWith("*")) {
                    buffer.append(line.substring(1));
                } else {
                    buffer.append(line);
                }
            }
            commentStrings[i] = buffer.toString();
        }
        return commentStrings;
    }

    private static class CStyleCommentPredicate
    implements JSElementPredicate {
        private CStyleCommentPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSChangeToEndOfLineCommentIntention$CStyleCommentPredicate", "satisfiedBy"));
            }
            if (!(element instanceof PsiComment)) {
                return false;
            }
            PsiComment comment = (PsiComment)element;
            IElementType type = comment.getTokenType();
            if (!JSTokenTypes.C_STYLE_COMMENT.equals(type)) {
                return false;
            }
            PsiElement sibling = PsiTreeUtil.nextLeaf((PsiElement)comment);
            if (!(sibling instanceof PsiWhiteSpace)) {
                return false;
            }
            String whitespaceText = sibling.getText();
            return whitespaceText.indexOf(10) >= 0 || whitespaceText.indexOf(13) >= 0;
        }
    }
}

