/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.comment;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.util.JSPsiTreeUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSMoveCommentToSeparateLineIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        CommentOnLineWithSourcePredicate commentOnLineWithSourcePredicate = new CommentOnLineWithSourcePredicate();
        if (commentOnLineWithSourcePredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/comment/JSMoveCommentToSeparateLineIntention", "getElementPredicate"));
        }
        return commentOnLineWithSourcePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiComment selectedComment;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSMoveCommentToSeparateLineIntention", "processIntention"));
        }
        PsiComment elementToCheck = selectedComment = (PsiComment)element;
        do {
            if ((elementToCheck = PsiTreeUtil.prevLeaf((PsiElement)elementToCheck)) != null) continue;
            return;
        } while (!JSPsiTreeUtil.isLineBreakWhiteSpace((PsiElement)elementToCheck));
        PsiWhiteSpace whiteSpace = (PsiWhiteSpace)elementToCheck;
        PsiElement commentElement = JSElementFactory.addElementBefore((PsiElement)whiteSpace, selectedComment.getText());
        JSElementFactory.addElementBefore(commentElement, "\n");
        JSElementFactory.removeElement((PsiElement)selectedComment);
    }

    private static class CommentOnLineWithSourcePredicate
    implements JSElementPredicate {
        private CommentOnLineWithSourcePredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSMoveCommentToSeparateLineIntention$CommentOnLineWithSourcePredicate", "satisfiedBy"));
            }
            if (!(element instanceof PsiComment)) {
                return false;
            }
            PsiComment comment = (PsiComment)element;
            IElementType type = comment.getTokenType();
            if (!JSTokenTypes.C_STYLE_COMMENT.equals(type) && !JSTokenTypes.END_OF_LINE_COMMENT.equals(type)) {
                return false;
            }
            PsiElement prevSibling = PsiTreeUtil.prevLeaf((PsiElement)element);
            if (prevSibling == null) {
                return false;
            }
            if (!(prevSibling instanceof PsiWhiteSpace)) {
                return true;
            }
            String prevSiblingText = prevSibling.getText();
            if (prevSiblingText.indexOf(10) < 0 && prevSiblingText.indexOf(13) < 0) {
                return true;
            }
            PsiElement nextSibling = PsiTreeUtil.nextLeaf((PsiElement)element);
            if (!(nextSibling instanceof PsiWhiteSpace)) {
                return true;
            }
            String nextSiblingText = nextSibling.getText();
            return nextSiblingText.indexOf(10) < 0 && nextSiblingText.indexOf(13) < 0;
        }
    }
}

