/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.initialization.JSVariablesWithInitializerPredicate;
import org.intellij.idea.lang.javascript.intention.initialization.TypeScriptVariablePredicate;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class TypeScriptSpecifyTypeExplicitlyIntention
extends JSIntention {
    private static final JSElementPredicate PREDICATE = new TypeScriptVariablePredicate(){

        @Override
        protected boolean checkVariable(TypeScriptVariable variable) {
            return TypeScriptSpecifyTypeExplicitlyIntention.checkVariable(variable);
        }
    };

    private static boolean checkVariable(TypeScriptVariable variable) {
        return variable.getTypeElement() == null && variable.hasInitializer();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        ASTNode newVarStatement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptSpecifyTypeExplicitlyIntention", "processIntention"));
        }
        if (!(element instanceof TypeScriptVariable)) {
            return;
        }
        TypeScriptVariable variable = (TypeScriptVariable)element;
        if (!TypeScriptSpecifyTypeExplicitlyIntention.checkVariable(variable)) {
            return;
        }
        PsiFile containingFile = variable.getContainingFile();
        String newTypeDeclaration = JSVariablesWithInitializerPredicate.getTypeString(containingFile, (JSVariable)variable);
        if (StringUtil.isEmpty((String)newTypeDeclaration)) {
            return;
        }
        StringBuilder declarationBuffer = new StringBuilder();
        declarationBuffer.append("var ");
        declarationBuffer.append(variable.getName());
        declarationBuffer.append(":");
        declarationBuffer.append(newTypeDeclaration);
        JSExpression initializer = variable.getInitializer();
        if (initializer != null) {
            declarationBuffer.append("=");
            declarationBuffer.append(initializer.getText());
        }
        if ((newVarStatement = JSChangeUtil.createStatementFromText((Project)containingFile.getProject(), (String)declarationBuffer.toString(), (JSLanguageDialect)JavaScriptSupportLoader.TYPESCRIPT)) == null) {
            return;
        }
        PsiElement psiElement = newVarStatement.getPsi();
        TypeScriptVariable variableChild = (TypeScriptVariable)PsiTreeUtil.getChildOfType((PsiElement)psiElement, TypeScriptVariable.class);
        if (variableChild == null) {
            return;
        }
        variable.replace((PsiElement)variableChild);
        JSElementFactory.reformat((PsiElement)variableChild);
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = PREDICATE;
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptSpecifyTypeExplicitlyIntention", "getElementPredicate"));
        }
        return jSElementPredicate;
    }
}

