/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSRemoveRedundantElseIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        RemoveRedundantElsePredicate removeRedundantElsePredicate = new RemoveRedundantElsePredicate();
        if (removeRedundantElsePredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/trivialif/JSRemoveRedundantElseIntention", "getElementPredicate"));
        }
        return removeRedundantElsePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSRemoveRedundantElseIntention", "processIntention"));
        }
        JSIfStatement ifStatement = (JSIfStatement)element;
        JSStatement thenBranch = ifStatement.getThen();
        JSStatement elseBranch = ifStatement.getElse();
        assert (thenBranch != null);
        assert (elseBranch != null);
        String newIfText = IF_STATEMENT_PREFIX + ifStatement.getCondition().getText() + ')' + thenBranch.getText();
        String elseText = elseBranch.getText();
        String newStatement = elseBranch instanceof JSBlockStatement ? elseText.substring(elseText.indexOf(123) + 1, elseText.lastIndexOf(125) - 1).trim() : elseText;
        JSElementFactory.addStatementAfter((JSStatement)ifStatement, newStatement);
        JSElementFactory.replaceStatement((JSStatement)ifStatement, newIfText);
    }

    private static class RemoveRedundantElsePredicate
    implements JSElementPredicate {
        private RemoveRedundantElsePredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSRemoveRedundantElseIntention$RemoveRedundantElsePredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)element;
            if (ErrorUtil.containsError((PsiElement)ifStatement)) {
                return false;
            }
            JSStatement elseBranch = ifStatement.getElse();
            JSStatement thenBranch = ifStatement.getThen();
            if (elseBranch == null) {
                return false;
            }
            while (thenBranch != null && thenBranch instanceof JSBlockStatement) {
                JSStatement[] thenStatements = ((JSBlockStatement)thenBranch).getStatements();
                if (thenStatements.length != 1) {
                    return false;
                }
                thenBranch = thenStatements[0];
            }
            return thenBranch != null && thenBranch instanceof JSReturnStatement;
        }
    }
}

