/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.BinaryOperatorUtils;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSReplaceIfWithConditionalIntention
extends JSIntention {
    private static final char TERNARY_QUESTION = '?';
    private static final char TERNARY_SEMICOLON = ':';
    @NonNls
    private static final String RETURN_KEYWORD = "return ";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ReplaceIfWithConditionalPredicate replaceIfWithConditionalPredicate = new ReplaceIfWithConditionalPredicate();
        if (replaceIfWithConditionalPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/trivialif/JSReplaceIfWithConditionalIntention", "getElementPredicate"));
        }
        return replaceIfWithConditionalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSReplaceIfWithConditionalIntention", "processIntention"));
        }
        JSIfStatement ifStatement = (JSIfStatement)(element.getParent() instanceof JSIfStatement ? element.getParent() : element);
        assert (ifStatement != null);
        if (ReplaceIfWithConditionalPredicate.isReplaceableAssignment(ifStatement)) {
            StringBuilder newStatement = new StringBuilder();
            JSReplaceIfWithConditionalIntention.getAssignmentReplacement(newStatement, ifStatement);
            newStatement.append(';');
            JSElementFactory.replaceStatement((JSStatement)ifStatement, newStatement.toString());
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement)) {
            StringBuilder newStatement = new StringBuilder(RETURN_KEYWORD);
            JSReplaceIfWithConditionalIntention.getReturnReplacement(newStatement, ifStatement);
            newStatement.append(';');
            JSElementFactory.replaceStatement((JSStatement)ifStatement, newStatement.toString());
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableImplicitReturn(ifStatement)) {
            JSExpression condition = ifStatement.getCondition();
            JSReturnStatement thenBranch = (JSReturnStatement)ConditionalUtils.stripBraces(ifStatement.getThen());
            JSReturnStatement elseBranch = (JSReturnStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)ifStatement, JSReturnStatement.class);
            String newStatement = JSReplaceIfWithConditionalIntention.getImplicitReturnReplacement(condition, thenBranch, elseBranch);
            JSElementFactory.replaceStatement((JSStatement)ifStatement, newStatement);
            if (elseBranch != null) {
                JSElementFactory.removeElement((PsiElement)elseBranch);
            }
        }
    }

    private static void getAssignmentReplacement(StringBuilder buffer, JSIfStatement ifStatement) {
        JSExpression condition = ifStatement.getCondition();
        JSExpressionStatement thenBranch = (JSExpressionStatement)ConditionalUtils.stripBraces(ifStatement.getThen());
        JSAssignmentExpression thenAssign = (JSAssignmentExpression)thenBranch.getExpression();
        JSExpression thenRhs = thenAssign.getROperand();
        String operator = BinaryOperatorUtils.getOperatorText(thenAssign.getOperationSign());
        JSStatement elseBranch = ifStatement.getElse();
        assert (thenRhs != null);
        buffer.append(thenAssign.getLOperand().getText()).append(operator).append(ParenthesesUtils.getParenthesized(condition, 15)).append('?').append(ParenthesesUtils.getParenthesized(thenRhs, 15)).append(':');
        if (elseBranch instanceof JSIfStatement) {
            JSReplaceIfWithConditionalIntention.getAssignmentReplacement(buffer, (JSIfStatement)elseBranch);
            return;
        }
        JSExpressionStatement strippedElseBranch = (JSExpressionStatement)ConditionalUtils.stripBraces(elseBranch);
        JSAssignmentExpression elseAssign = (JSAssignmentExpression)strippedElseBranch.getExpression();
        JSExpression elseRhs = elseAssign.getROperand();
        assert (elseRhs != null);
        buffer.append(ParenthesesUtils.getParenthesized(elseRhs, 15));
    }

    private static void getReturnReplacement(StringBuilder buffer, JSIfStatement ifStatement) {
        JSStatement thenBranch = ifStatement.getThen();
        JSReturnStatement thenReturn = (JSReturnStatement)ConditionalUtils.stripBraces(thenBranch);
        JSStatement elseBranch = ifStatement.getElse();
        buffer.append(ParenthesesUtils.getParenthesized(ifStatement.getCondition(), 15)).append('?').append(ParenthesesUtils.getParenthesized(thenReturn.getExpression(), 15)).append(':');
        if (elseBranch instanceof JSIfStatement) {
            JSReplaceIfWithConditionalIntention.getReturnReplacement(buffer, (JSIfStatement)elseBranch);
            return;
        }
        JSReturnStatement elseReturn = (JSReturnStatement)ConditionalUtils.stripBraces(elseBranch);
        buffer.append(ParenthesesUtils.getParenthesized(elseReturn.getExpression(), 15));
    }

    private static String getImplicitReturnReplacement(JSExpression condition, JSReturnStatement thenBranch, JSReturnStatement elseBranch) {
        assert (thenBranch != null);
        assert (elseBranch != null);
        JSExpression thenReturnValue = thenBranch.getExpression();
        JSExpression elseReturnValue = elseBranch.getExpression();
        String thenValue = ParenthesesUtils.getParenthesized(thenReturnValue, 15);
        String elseValue = ParenthesesUtils.getParenthesized(elseReturnValue, 15);
        String conditionText = ParenthesesUtils.getParenthesized(condition, 15);
        return RETURN_KEYWORD + conditionText + '?' + thenValue + ':' + elseValue + ';';
    }

    private static class ReplaceIfWithConditionalPredicate
    implements JSElementPredicate {
        private ReplaceIfWithConditionalPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSReplaceIfWithConditionalIntention$ReplaceIfWithConditionalPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSElement)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if (ErrorUtil.containsError(parent)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSExpression condition = ifStatement.getCondition();
            if (condition == null || !condition.isValid()) {
                return false;
            }
            if (ReplaceIfWithConditionalPredicate.isReplaceableAssignment(ifStatement)) {
                return true;
            }
            if (ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement)) {
                return true;
            }
            return ReplaceIfWithConditionalPredicate.isReplaceableImplicitReturn(ifStatement);
        }

        public static boolean isReplaceableImplicitReturn(JSIfStatement ifStatement) {
            PsiElement nextStatement = JSElementFactory.getNonWhiteSpaceSibling((PsiElement)ifStatement, true);
            if (!(nextStatement instanceof JSReturnStatement)) {
                return false;
            }
            JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
            if (!(thenBranch instanceof JSReturnStatement)) {
                return false;
            }
            return ((JSReturnStatement)thenBranch).getExpression() != null && ((JSReturnStatement)nextStatement).getExpression() != null;
        }

        public static boolean isReplaceableReturn(JSIfStatement ifStatement) {
            JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
            JSStatement elseBranch = ConditionalUtils.stripBraces(ifStatement.getElse());
            if (!(thenBranch instanceof JSReturnStatement)) {
                return false;
            }
            if (elseBranch instanceof JSIfStatement) {
                return ReplaceIfWithConditionalPredicate.isReplaceableReturn((JSIfStatement)elseBranch);
            }
            if (!(elseBranch instanceof JSReturnStatement)) {
                return false;
            }
            return ((JSReturnStatement)thenBranch).getExpression() != null && ((JSReturnStatement)elseBranch).getExpression() != null;
        }

        public static boolean isReplaceableAssignment(JSIfStatement ifStatement) {
            IElementType elseSign;
            JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
            if (thenBranch == null) {
                return false;
            }
            if (!ConditionalUtils.isAssignment(thenBranch)) {
                return false;
            }
            JSStatement elseBranch = ConditionalUtils.stripBraces(ifStatement.getElse());
            if (elseBranch == null) {
                return false;
            }
            if (elseBranch instanceof JSIfStatement) {
                return ReplaceIfWithConditionalPredicate.isReplaceableAssignment((JSIfStatement)elseBranch);
            }
            if (!ConditionalUtils.isAssignment(elseBranch)) {
                return false;
            }
            JSAssignmentExpression thenExpression = (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
            JSAssignmentExpression elseExpression = (JSAssignmentExpression)((JSExpressionStatement)elseBranch).getExpression();
            IElementType thenSign = thenExpression.getOperationSign();
            if (!thenSign.equals(elseSign = elseExpression.getOperationSign())) {
                return false;
            }
            JSExpression thenLhs = thenExpression.getLOperand();
            if (thenExpression.getROperand() == null) {
                return false;
            }
            if (elseExpression.getROperand() == null || elseExpression.getLOperand() == null) {
                return false;
            }
            JSExpression thenRhs = thenExpression.getROperand();
            assert (thenRhs != null);
            JSExpression elseRhs = elseExpression.getROperand();
            if (elseRhs == null) {
                return false;
            }
            JSExpression elseLhs = elseExpression.getLOperand();
            return EquivalenceChecker.expressionsAreEquivalent((JSExpression)thenLhs, (JSExpression)elseLhs);
        }
    }
}

