/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.ComparisonUtils;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSElementFactory {
    @NonNls
    private static final String DUMMY_FILE_NAME_PREFIX = "dummy.";
    private static final Class[] WHITESPACE_CLASS = new Class[]{PsiWhiteSpace.class};
    private static final Logger LOG = Logger.getInstance(JSElementFactory.class);

    private JSElementFactory() {
    }

    public static PsiElement addElementBefore(@NotNull PsiElement element, @NotNull PsiElement newElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementBefore"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementBefore"));
        }
        ASTNode oldElementParentNode = element.getNode();
        PsiElement parentNode = element.getParent();
        ASTNode newElementParentNode = parentNode.getNode();
        ASTNode newElementNode = newElement.getNode();
        if (newElementParentNode == null || newElementNode == null) {
            return null;
        }
        newElementParentNode.addChild(newElementNode, oldElementParentNode);
        return newElement;
    }

    public static PsiElement addElementAfter(@NotNull PsiElement element, @NotNull PsiElement newElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementAfter"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementAfter"));
        }
        ASTNode elementNode = element.getNode();
        ASTNode oldElementParentNode = elementNode == null ? null : elementNode.getTreeNext();
        PsiElement parentNode = element.getParent();
        ASTNode newElementParentNode = parentNode.getNode();
        ASTNode newElementNode = newElement.getNode();
        if (newElementParentNode == null || newElementNode == null) {
            return null;
        }
        newElementParentNode.addChild(newElementNode, oldElementParentNode);
        return newElement;
    }

    public static PsiElement addElementBefore(@NotNull PsiElement element, @NonNls @NotNull String elementText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementBefore"));
        }
        if (elementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementText", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementBefore"));
        }
        PsiElement newElement = JSElementFactory.createDummyFile(element.getProject(), elementText).getFirstChild();
        assert (newElement != null);
        return JSElementFactory.addElementBefore(element, newElement);
    }

    public static PsiElement addElementAfter(@NotNull PsiElement element, @NotNull String elementText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementAfter"));
        }
        if (elementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementText", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementAfter"));
        }
        PsiElement newElement = JSElementFactory.createDummyFile(element.getProject(), elementText).getFirstChild();
        assert (newElement != null);
        return JSElementFactory.addElementAfter(element, newElement);
    }

    public static ASTNode createElementFromText(Project project, String text) {
        PsiElement element = JSElementFactory.createDummyFile(project, text).getFirstChild();
        assert (element != null);
        return element.getNode();
    }

    @NotNull
    private static PsiFile createDummyFile(Project project, String text) {
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(JavaScriptSupportLoader.JAVASCRIPT.getLanguage());
        assert (def != null);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(DUMMY_FILE_NAME_PREFIX + JavaScriptSupportLoader.JAVASCRIPT.getDefaultExtension(), text);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "createDummyFile"));
        }
        return psiFile;
    }

    public static JSStatement replaceElementWithStatement(@NotNull JSElement element, @NonNls @NotNull String statementText) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceElementWithStatement"));
        }
        if (statementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementText", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceElementWithStatement"));
        }
        ASTNode newStatementNode = JSChangeUtil.createStatementFromText((Project)element.getProject(), (String)statementText, (JSLanguageDialect)JSUtils.getDialect((PsiFile)element.getContainingFile()));
        ASTNode oldStatementParentNode = element.getNode();
        PsiElement parentNode = element.getParent();
        ASTNode newStatementParentNode = parentNode.getNode();
        if (newStatementParentNode == null || oldStatementParentNode == null || newStatementNode == null) {
            return null;
        }
        newStatementParentNode.replaceChild(oldStatementParentNode, newStatementNode);
        JSElementFactory.reformat(parentNode);
        return (JSStatement)newStatementNode.getPsi();
    }

    public static JSExpression replaceExpression(@NotNull JSExpression expression, @NonNls @NotNull String text) throws IncorrectOperationException {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpression"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpression"));
        }
        ASTNode newExpressionNode = JSChangeUtil.createExpressionFromText((Project)expression.getProject(), (String)text, (JSLanguageDialect)JSUtils.getDialect((PsiFile)expression.getContainingFile()));
        return newExpressionNode != null ? JSElementFactory.replaceExpression(expression, (JSExpression)newExpressionNode.getPsi()) : expression;
    }

    public static JSExpression replaceExpression(@NotNull JSExpression expression, @NotNull JSExpression newExpression) throws IncorrectOperationException {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpression"));
        }
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpression"));
        }
        ASTNode newExpressionNode = newExpression.getNode();
        ASTNode oldExpressionNode = expression.getNode();
        PsiElement parentNode = expression.getParent();
        ASTNode grandParentNode = parentNode.getNode();
        if (grandParentNode == null || oldExpressionNode == null || newExpressionNode == null) {
            return null;
        }
        grandParentNode.replaceChild(oldExpressionNode, newExpressionNode);
        JSElementFactory.reformat(parentNode);
        return (JSExpression)newExpressionNode.getPsi();
    }

    public static JSStatement replaceStatement(@NotNull JSStatement statement, @NonNls @NotNull String text) throws IncorrectOperationException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceStatement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceStatement"));
        }
        ASTNode newStatementNode = JSChangeUtil.createStatementFromText((Project)statement.getProject(), (String)text, (JSLanguageDialect)JSUtils.getDialect((PsiFile)statement.getContainingFile()));
        ASTNode oldStatementNode = statement.getNode();
        PsiElement parentNode = statement.getParent();
        ASTNode newStatementParentNode = parentNode.getNode();
        if (newStatementParentNode == null || oldStatementNode == null || newStatementNode == null) {
            return null;
        }
        newStatementParentNode.replaceChild(oldStatementNode, newStatementNode);
        JSElementFactory.reformat(newStatementNode.getPsi());
        return (JSStatement)newStatementNode.getPsi();
    }

    public static JSStatement addStatementBefore(@NotNull JSStatement statement, @NonNls @NotNull String previousStatementText) throws IncorrectOperationException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addStatementBefore"));
        }
        if (previousStatementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousStatementText", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addStatementBefore"));
        }
        ASTNode newStatementNode = JSChangeUtil.createStatementFromText((Project)statement.getProject(), (String)previousStatementText, (JSLanguageDialect)JSUtils.getDialect((PsiFile)statement.getContainingFile()));
        ASTNode oldStatementParentNode = statement.getNode();
        PsiElement parentNode = statement.getParent();
        ASTNode newStatementParentNode = parentNode.getNode();
        if (newStatementParentNode == null || newStatementNode == null) {
            return null;
        }
        newStatementParentNode.addChildren(newStatementNode, null, oldStatementParentNode);
        JSElementFactory.reformat(parentNode);
        return (JSStatement)newStatementNode.getPsi();
    }

    public static JSStatement addStatementAfter(@NotNull JSStatement statement, @NonNls @NotNull String nextStatementText) throws IncorrectOperationException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addStatementAfter"));
        }
        if (nextStatementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nextStatementText", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addStatementAfter"));
        }
        ASTNode newStatementNode = JSChangeUtil.createStatementFromText((Project)statement.getProject(), (String)nextStatementText, (JSLanguageDialect)JSUtils.getDialect((PsiFile)statement.getContainingFile()));
        ASTNode statementNode = statement.getNode();
        ASTNode oldStatementParentNode = statementNode == null ? null : statementNode.getTreeNext();
        PsiElement parentNode = statement.getParent();
        ASTNode newStatementParentNode = parentNode.getNode();
        if (newStatementParentNode == null || newStatementNode == null) {
            return null;
        }
        newStatementParentNode.addChildren(newStatementNode, null, oldStatementParentNode);
        JSElementFactory.reformat(parentNode);
        return (JSStatement)newStatementNode.getPsi();
    }

    public static void addRangeBefore(JSStatement[] statements, JSStatement statement) throws IncorrectOperationException {
        JSElementFactory.addRangeBefore(statements, 0, statements.length, statement);
    }

    public static void addRangeAfter(JSStatement[] statements, JSStatement statement) throws IncorrectOperationException {
        JSElementFactory.addRangeAfter(statements, 0, statements.length, statement);
    }

    public static void addRangeBefore(JSStatement[] statements, int start, int length, JSStatement statement) throws IncorrectOperationException {
        for (int index = start; index < length; ++index) {
            JSElementFactory.addStatementBefore(statement, statements[index].getText());
        }
    }

    public static void addRangeAfter(JSStatement[] statements, int start, int length, JSStatement statement) throws IncorrectOperationException {
        int index = length;
        while (--index >= start) {
            JSElementFactory.addStatementAfter(statement, statements[index].getText());
        }
    }

    public static void replaceExpressionWithNegatedExpression(@NotNull JSExpression newExpression, @NotNull JSExpression exp) throws IncorrectOperationException {
        String replacementString;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpressionWithNegatedExpression"));
        }
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpressionWithNegatedExpression"));
        }
        JSExpression expressionToReplace = BoolUtils.findNegation(exp);
        if (expressionToReplace == null) {
            expressionToReplace = exp;
            if (ComparisonUtils.isComparisonOperator(newExpression)) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)newExpression;
                IElementType operationSign = binaryExpression.getOperationSign();
                String negatedComparison = ComparisonUtils.getNegatedOperatorText(operationSign);
                JSExpression leftOperand = binaryExpression.getLOperand();
                JSExpression rightOperand = binaryExpression.getROperand();
                assert (rightOperand != null);
                replacementString = leftOperand.getText() + negatedComparison + rightOperand.getText();
            } else {
                replacementString = '!' + ParenthesesUtils.getParenthesized(newExpression, 3);
            }
        } else {
            replacementString = newExpression.getText();
        }
        JSElementFactory.replaceExpression(expressionToReplace, replacementString);
    }

    public static void replaceExpressionWithNegatedExpressionString(JSExpression exp, String newExpression) throws IncorrectOperationException {
        assert (exp != null);
        JSExpression expressionToReplace = BoolUtils.findNegation(exp);
        String replacementString = newExpression;
        if (expressionToReplace == null) {
            expressionToReplace = exp;
            replacementString = "!(" + newExpression + ')';
        } else {
            PsiElement parent = expressionToReplace.getParent();
            if (parent instanceof JSBinaryExpression && exp instanceof JSBinaryExpression) {
                IElementType parentSign = ((JSBinaryExpression)parent).getOperationSign();
                IElementType childSign = ((JSBinaryExpression)exp).getOperationSign();
                if (childSign == JSTokenTypes.ANDAND && parentSign == JSTokenTypes.ANDAND) {
                    replacementString = "(" + newExpression + ")";
                }
            }
        }
        JSElementFactory.replaceExpression(expressionToReplace, replacementString);
    }

    public static void replaceStatementWithUnwrapping(JSStatement statement, JSStatement newBranch) throws IncorrectOperationException {
        if (!(newBranch instanceof JSBlockStatement)) {
            JSElementFactory.replaceStatement(statement, newBranch.getText());
            return;
        }
        JSBlockStatement parentBlock = (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)newBranch, JSBlockStatement.class);
        if (parentBlock == null) {
            JSElementFactory.replaceStatement(statement, newBranch.getText());
            return;
        }
        JSBlockStatement block = (JSBlockStatement)newBranch;
        if (ControlFlowUtils.containsConflictingDeclarations((JSBlockStatement)block, (JSBlockStatement)parentBlock)) {
            JSElementFactory.replaceStatement(statement, newBranch.getText());
            return;
        }
        PsiElement containingElement = statement.getParent();
        assert (containingElement instanceof JSStatement);
        JSElementFactory.addRangeBefore(block.getStatements(), statement);
        JSElementFactory.removeElement((PsiElement)statement);
    }

    public static void removeElement(PsiElement element) {
        FormatFixer ff = FormatFixer.create((PsiElement)element, (FormatFixer.Mode)FormatFixer.Mode.FirstLinebreak);
        element.delete();
        ff.fixFormat();
    }

    public static void removeRange(@NotNull PsiElement from, @NotNull PsiElement to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "removeRange"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "removeRange"));
        }
        FormatFixer ff = FormatFixer.create((PsiElement)from, (PsiElement)to, (FormatFixer.Mode)FormatFixer.Mode.FirstLinebreak);
        from.getParent().deleteChildRange(from, to);
        ff.fixFormat();
    }

    public static void reformat(PsiElement statement) throws IncorrectOperationException {
        if (statement.getContainingFile() instanceof JSFile) {
            try {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)statement.getManager().getProject());
                codeStyleManager.reformatNewlyAddedElement(statement.getParent().getNode(), statement.getNode());
                codeStyleManager.reformat(statement);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                String text = statement.getText();
                String parentText = statement.getParent().getText();
                Attachment statementAttachment = new Attachment("statement.js", text);
                Attachment parentAttachment = new Attachment("parent.js", parentText);
                LOG.error("Error while reformatting " + e.getMessage(), new Attachment[]{statementAttachment, parentAttachment});
            }
        }
    }

    public static PsiElement getNonWhiteSpaceSibling(PsiElement element, boolean forward) {
        return forward ? PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])WHITESPACE_CLASS) : PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])WHITESPACE_CLASS);
    }

    public static boolean isFileReadOnly(Project project, PsiFile file) {
        ReadonlyStatusHandler instance = ReadonlyStatusHandler.getInstance((Project)project);
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null && instance.ensureFilesWritable(new VirtualFile[]{virtualFile}).hasReadonlyFiles();
    }
}

