/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.google.common.collect.Iterables;
import com.intellij.database.dataSource.DatabaseObject;
import com.intellij.database.dataSource.DatabaseTableData;
import com.intellij.database.dataSource.DatabaseTableFieldData;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class DatabaseKIFK
extends DatabaseObject
implements DasTableChild {
    public static final Pattern COLUMN_SPLITTER_PATTERN = Pattern.compile("\\s*,\\s*");
    static final DasColumn[] EMPTY_ARRAY = new DasColumn[0];
    protected final DasTable myTable;
    private String myName;
    private String[] myColumnNames = ArrayUtil.EMPTY_STRING_ARRAY;
    private boolean myUnique;
    private DasColumn[] myColumns = EMPTY_ARRAY;

    DatabaseKIFK(DasTable table) {
        this.myTable = table;
    }

    DatabaseKIFK(String name, boolean unique, DasColumn ... columns) {
        assert (columns.length > 0);
        this.myName = DbUtil.intern((String)name);
        this.myUnique = unique;
        this.myColumns = columns;
        this.myTable = columns[0].getTable();
        this.myColumnNames = new String[this.myColumns.length];
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            this.myColumnNames[i] = columns[i].getName();
            assert (this.myTable == columns[i].getTable());
        }
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseKIFK", "getKind"));
        }
        return objectKind;
    }

    public DasTable getTable() {
        return this.myTable;
    }

    @NotNull
    public String getName() {
        String string = (String)ObjectUtils.notNull((Object)this.myName, (Object)DasUtil.NO_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseKIFK", "getName"));
        }
        return string;
    }

    public String getTableName() {
        return this.myTable.getName();
    }

    @NotNull
    public MultiRef<? extends DasTypedObject> getColumnsRef() {
        MultiRef<DasTypedObject> multiRef = DatabaseKIFK.asRef(this.myColumnNames, this.myColumns);
        if (multiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseKIFK", "getColumnsRef"));
        }
        return multiRef;
    }

    @NotNull
    protected static MultiRef<DasTypedObject> asRef(final String[] columnNames, final DasColumn[] columns) {
        MultiRef<DasTypedObject> multiRef = new MultiRef<DasTypedObject>(){

            public MultiRef.It<DasTypedObject> iterate() {
                return new MultiRef.It<DasTypedObject>(){
                    int idx = -1;

                    @Nullable
                    public DasTypedObject resolve() {
                        return (DasTypedObject)DatabaseKIFK.itemAt(this.idx, columns);
                    }

                    public boolean hasNext() {
                        return this.idx < columnNames.length - 1;
                    }

                    public String next() {
                        return columnNames[++this.idx];
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public Iterable<String> names() {
                return Arrays.asList(columnNames);
            }

            public Iterable<? extends DasTypedObject> resolveObjects() {
                return JBIterable.of((Object[])columns).filter(Condition.NOT_NULL);
            }

            public int size() {
                return columnNames.length;
            }
        };
        if (multiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseKIFK", "asRef"));
        }
        return multiRef;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setColumnNames(Iterable<String> columnNames) {
        this.myColumnNames = (String[])Iterables.toArray(columnNames, String.class);
    }

    public boolean isUnique() {
        return this.myUnique;
    }

    public void setUnique(boolean unique) {
        this.myUnique = unique;
    }

    public void resolveReferences(Collection<DatabaseTableData> tables) {
        this.myColumns = new DatabaseTableFieldData[this.myColumnNames.length];
        for (int i = 0; i < this.myColumnNames.length; ++i) {
            this.myColumns[i] = (DasColumn)QNameUtil.findByName(this.myColumnNames[i], this.myTable.getDbChildren(DasColumn.class, ObjectKind.COLUMN));
        }
    }

    @Nullable
    protected static <E> E itemAt(int ordinal, E[] values) {
        return ordinal >= 0 && ordinal < values.length ? (E)values[ordinal] : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseKIFK key = (DatabaseKIFK)o;
        if (this.myUnique != key.myUnique) {
            return false;
        }
        if (!Arrays.equals(this.myColumnNames, key.myColumnNames)) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(key.myName) : key.myName != null) {
            return false;
        }
        return !(this.myTable != null ? !this.myTable.equals(key.myTable) : key.myTable != null);
    }

    public int hashCode() {
        int result = this.myTable != null ? this.myTable.hashCode() : 0;
        result = 31 * result + (this.myName != null ? this.myName.hashCode() : 0);
        result = 31 * result + (this.myColumnNames != null ? Arrays.hashCode(this.myColumnNames) : 0);
        result = 31 * result + (this.myUnique ? 1 : 0);
        return result;
    }

    @Nullable
    public DasObject getDbParent() {
        return this.myTable;
    }
}

