/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseModelModernLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.util.LoaderContext;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ObjectUtils;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.BaseFacade;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DatabaseModelLoader {
    static void performIntrospection(@NotNull LoaderContext context, @NotNull DasModel model, @NotNull Connection connection, @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator progressIndicator) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        Rdbms rdbms = DataSourceUiUtil.getRdbmsForIntrospection(context.getFamilyId());
        boolean forceLegacyIntro = DatabaseModelLoader.whetherForcedLegacy(context);
        DatabaseModelLoader.performKnownIntrospection(model, (Rdbms)ObjectUtils.chooseNotNull((Object)rdbms, (Object)UnknownDatabase.RDBMS), connection, context, metaData, progressIndicator, forceLegacyIntro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performKnownIntrospection(@NotNull DasModel model, @NotNull Rdbms rdbms, @NotNull Connection connection, @NotNull LoaderContext context, @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator progressIndicator, boolean forceLegacy) {
        PrimeIntermediateFacade remoteFacade;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        RemoteConnection remoteConnection = (RemoteConnection)RemoteUtil.castToRemote((Object)connection, RemoteConnection.class);
        assert (remoteConnection != null);
        try {
            RemoteFacade jpdaFacade = remoteConnection.jpdaFacade(rdbms.code);
            remoteFacade = (PrimeIntermediateFacade)RemoteUtil.castToLocal((Object)jpdaFacade, PrimeIntermediateFacade.class);
            assert (remoteFacade != null);
            assert (remoteFacade.rdbms().code.equals(rdbms.code));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        AdaptIntermediateFacade intermediateFacade = null;
        try {
            intermediateFacade = new AdaptIntermediateFacade(remoteFacade);
            BaseFacade facade = new BaseFacade((IntegralIntermediateFacade)intermediateFacade);
            try {
                facade.connect();
                DatabaseModelModernLoader.performModernIntrospection((DBFacade)facade, context, model, progressIndicator, forceLegacy);
            }
            catch (Exception e) {
                context.getErrorHandler().addError(e.getMessage(), (Throwable)e);
            }
            finally {
                facade.disconnect();
            }
        }
        finally {
            if (intermediateFacade != null) {
                intermediateFacade.disconnect();
            }
            remoteFacade.disconnect();
        }
    }

    private static boolean whetherForcedLegacy(@NotNull LoaderContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "whetherForcedLegacy"));
        }
        LocalDataSource dataSource = context.getDataSource();
        return dataSource != null && dataSource.useLegacyIntrospector();
    }
}

