/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseArgument;
import com.intellij.database.dataSource.DatabaseObject;
import com.intellij.database.dataSource.DatabaseSchema;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class DatabaseProcedure
extends DatabaseObject
implements DasRoutine {
    private String myName;
    private DatabaseSchema mySchema;
    private String myPackage;
    private DasRoutine.Kind myRoutineKind;
    private String myComment;
    private volatile State myState;

    public DatabaseProcedure(String name, @NotNull DatabaseSchema schema, String package_, DasRoutine.Kind routineKind) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dataSource/DatabaseProcedure", "<init>"));
        }
        this.myState = new State(Collections.emptyList(), null);
        this.myName = DbUtil.intern((String)name);
        this.mySchema = schema;
        this.myPackage = DbUtil.intern((String)package_, null);
        this.myRoutineKind = routineKind;
    }

    public DatabaseProcedure(String name, String schema, String catalog, String package_, DasRoutine.Kind type, DatabaseArgument returnParam, List<DatabaseArgument> parameters) {
        this(name, new DatabaseSchema(catalog, schema), package_, type);
        this.updateState(new State(parameters, returnParam));
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROUTINE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseProcedure", "getKind"));
        }
        return objectKind;
    }

    @NotNull
    public String getName() {
        String string = (String)ObjectUtils.notNull((Object)this.myName, (Object)DasUtil.NO_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseProcedure", "getName"));
        }
        return string;
    }

    public String getSchema() {
        return this.mySchema.getName();
    }

    public String getPackage() {
        return this.myPackage;
    }

    public String getCatalog() {
        return this.mySchema.getCatalog();
    }

    @NotNull
    public DasRoutine.Kind getRoutineKind() {
        DasRoutine.Kind kind = this.myRoutineKind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseProcedure", "getRoutineKind"));
        }
        return kind;
    }

    @NotNull
    public Iterable<DatabaseArgument> getArguments() {
        List<DatabaseArgument> list = this.myState.arguments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseProcedure", "getArguments"));
        }
        return list;
    }

    @Nullable
    public DatabaseArgument getReturnArgument() {
        return this.myState.returnArgument;
    }

    public void setRoutineKind(DasRoutine.Kind type) {
        this.myRoutineKind = type;
    }

    @Override
    public String getComment() {
        return this.myComment;
    }

    @NotNull
    public DatabaseSchema getDbParent() {
        DatabaseSchema databaseSchema = this.mySchema;
        if (databaseSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseProcedure", "getDbParent"));
        }
        return databaseSchema;
    }

    @Override
    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/dataSource/DatabaseProcedure", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dataSource/DatabaseProcedure", "getDbChildren"));
        }
        if (kind == ObjectKind.ARGUMENT || kind == ObjectKind.NONE) {
            DatabaseArgument retArg = this.getReturnArgument();
            JBIterable result = JBIterable.from(this.getArguments());
            if (retArg != null) {
                result = result.append(new Object[]{retArg});
            }
            JBIterable jBIterable = result;
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseProcedure", "getDbChildren"));
            }
            return jBIterable;
        }
        JBIterable<C> jBIterable = super.getDbChildren(clazz, kind);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseProcedure", "getDbChildren"));
        }
        return jBIterable;
    }

    public void setComment(String remarks) {
        this.myComment = DbUtil.intern((String)remarks);
    }

    @NonNls
    public String toString() {
        return "Procedure::" + (this.myPackage != null ? this.myPackage + "." + this.myName : this.myName);
    }

    void updateState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseProcedure", "updateState"));
        }
        this.myState = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseProcedure data = (DatabaseProcedure)o;
        if (this.myName != null ? !this.myName.equals(data.myName) : data.myName != null) {
            return false;
        }
        if (!this.mySchema.equals(data.mySchema)) {
            return false;
        }
        if (this.myPackage != null ? !this.myPackage.equals(data.myPackage) : data.myPackage != null) {
            return false;
        }
        State s1 = this.myState;
        State s2 = data.myState;
        if (!Comparing.equal(s1.arguments, s2.arguments)) {
            return false;
        }
        return Comparing.compare((Comparable)s1.returnArgument, (Comparable)s2.returnArgument) == 0;
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myPackage != null ? this.myPackage.hashCode() : 0);
        result = 31 * result + this.mySchema.hashCode();
        return result;
    }

    static class State {
        final List<DatabaseArgument> arguments;
        final DatabaseArgument returnArgument;

        public State(List<DatabaseArgument> arguments, DatabaseArgument returnArgument) {
            this.arguments = arguments;
            this.returnArgument = returnArgument;
        }
    }
}

