/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseObject;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class DatabaseSchema
extends DatabaseObject
implements DasNamespace,
Comparable<DatabaseSchema> {
    private final String myCatalog;
    private final String myName;
    private static final ConcurrentFactoryMap<String, DasObject> ourCatalogs = new ConcurrentFactoryMap<String, DasObject>(){

        @Nullable
        protected DasObject create(String key) {
            return new MyDatabase(key);
        }
    };

    public DatabaseSchema(String catalog, String name) {
        this.myCatalog = DbUtil.intern((String)StringUtil.nullize((String)catalog));
        this.myName = DbUtil.intern((String)StringUtil.nullize((String)name));
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SCHEMA;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseSchema", "getKind"));
        }
        return objectKind;
    }

    public String getCatalog() {
        return this.myCatalog;
    }

    @NotNull
    public String getName() {
        String string = (String)ObjectUtils.notNull((Object)this.myName, (Object)DasUtil.NO_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseSchema", "getName"));
        }
        return string;
    }

    @Nullable
    public DasObject getDbParent() {
        return (DasObject)ourCatalogs.get((Object)this.myCatalog);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseSchema schema1 = (DatabaseSchema)o;
        if (!this.myCatalog.equals(schema1.myCatalog)) {
            return false;
        }
        return this.myName.equals(schema1.myName);
    }

    public int hashCode() {
        int result = this.myCatalog.hashCode();
        result = 31 * result + this.myName.hashCode();
        return result;
    }

    @Override
    public int compareTo(DatabaseSchema o) {
        int result = Comparing.compare((Comparable)((Object)this.myCatalog), (Comparable)((Object)o.myCatalog));
        if (result != 0) {
            return result;
        }
        return Comparing.compare((Comparable)((Object)this.myName), (Comparable)((Object)o.myName));
    }

    public String toString() {
        return "DatabaseSchema{'" + this.myName + '\'' + ", catalog='" + this.myCatalog + '\'' + '}';
    }

    private static class MyDatabase
    extends DasObject.Adapter
    implements DasNamespace {
        private final String myKey;

        public MyDatabase(String key) {
            this.myKey = key;
        }

        @NotNull
        public String getName() {
            String string = this.myKey;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseSchema$MyDatabase", "getName"));
            }
            return string;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.DATABASE;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseSchema$MyDatabase", "getKind"));
            }
            return objectKind;
        }
    }
}

