/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.UniformLookSettingsProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionParamEditor<T>
extends ParamEditorBase<ProgressFieldWithCompletion<T>> {
    private static final Key<CompletionParamEditor> PARAM_EDITOR_KEY = Key.create((String)"CompletionParamEditor");
    protected static final Key<Boolean> FORCED_KEY = Key.create((String)"FORCED_KEY");
    private final CompletionProvider myProvider;
    private boolean mySupersedeTasks;
    private boolean myValidateOnDirtyCompletion;
    private boolean myAsyncUpdateOnCompletion;
    private boolean myReportErrorOnAutoPopup;
    protected List<T> myModel;
    protected final MyUpdater myUpdater;
    private boolean myDirty;
    private String myUpdateTitle;
    private String myForceRefreshTitle;
    private final ActionGroup myContextMenu;

    public CompletionParamEditor(@NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "<init>"));
        }
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "<init>"));
        }
        super(new ProgressFieldWithCompletion(interchange.getProject()), interchange, TypesRegistry.ParamEditor.FieldSize.LARGE, label, new AnAction[0]);
        this.mySupersedeTasks = false;
        this.myValidateOnDirtyCompletion = false;
        this.myAsyncUpdateOnCompletion = false;
        this.myReportErrorOnAutoPopup = false;
        this.myModel = Collections.emptyList();
        this.myUpdater = new MyUpdater();
        this.myDirty = true;
        this.myUpdateTitle = "Updating";
        this.myForceRefreshTitle = null;
        this.myContextMenu = new ActionGroup(){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                List items = CompletionParamEditor.this.getContextMenuEntries().toList();
                AnAction[] anActionArray = items.toArray(new AnAction[items.size()]);
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$1", "getChildren"));
                }
                return anActionArray;
            }
        };
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.getEditorComponent()));
        this.myProvider = new CompletionProvider();
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().installProvider((TextFieldWithAutoCompletionListProvider)this.myProvider);
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider((EditorSettingsProvider)new UniformLookSettingsProvider());
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                CompletionParamEditor.this.fireChanged();
            }
        });
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider(new EditorSettingsProvider(){

            public void customizeSettings(EditorEx editor) {
                EditorPopupHandler handler = EditorActionUtil.createEditorPopupHandler((ActionGroup)CompletionParamEditor.this.myContextMenu);
                editor.addEditorMouseListener((EditorMouseListener)handler);
                PARAM_EDITOR_KEY.set((UserDataHolder)editor, (Object)CompletionParamEditor.this);
            }
        });
    }

    @NotNull
    protected JBIterable<AnAction> getContextMenuEntries() {
        if (this.myForceRefreshTitle == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "getContextMenuEntries"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])new AnAction[]{MyForceRefresh.INSTANCE});
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "getContextMenuEntries"));
        }
        return jBIterable;
    }

    public void setSupersedeTasks(boolean supersedeTasks) {
        this.mySupersedeTasks = supersedeTasks;
    }

    public void setReportErrorOnAutoPopup(boolean reportErrorOnAutoPopup) {
        this.myReportErrorOnAutoPopup = reportErrorOnAutoPopup;
    }

    public void setValidateOnDirtyCompletion(boolean validateOnDirtyCompletion) {
        this.myValidateOnDirtyCompletion = validateOnDirtyCompletion;
    }

    protected void addUpdateOnShow() {
        new UiNotifyConnector(this.getEditorComponent(), new Activatable(){

            public void showNotify() {
                CompletionParamEditor.this.updateModelAtShow();
            }

            public void hideNotify() {
            }
        });
    }

    protected void onCompletion(boolean isAutoPopup) {
        if (!this.myValidateOnDirtyCompletion || !this.myDirty) {
            return;
        }
        this.myDirty = false;
        if (this.myAsyncUpdateOnCompletion) {
            this.updateModelAsync(isAutoPopup);
        } else {
            this.updateModelSync(isAutoPopup);
        }
    }

    protected void updateNowIfVisible() {
        if (((ProgressFieldWithCompletion)this.getEditorComponent()).isVisible()) {
            this.updateModelAsync(true);
        } else {
            this.setDirty(true);
        }
    }

    protected void setDirty(boolean dirty) {
        this.myDirty = dirty;
    }

    protected void setUpdateTitle(String updateTitle) {
        this.myUpdateTitle = updateTitle;
    }

    protected void resetVariants() {
        this.myModel = Collections.emptyList();
        this.myProvider.setItems(this.myModel);
        this.setDirty(true);
    }

    protected void setVariantsAndCompletionVariants(@NotNull List<T> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "setVariantsAndCompletionVariants"));
        }
        this.setCompletionVariants(variants);
        this.setVariants(variants);
    }

    protected void setVariants(@NotNull List<T> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "setVariants"));
        }
        this.myModel = variants;
    }

    protected void setCompletionVariants(@NotNull List<T> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "setCompletionVariants"));
        }
        this.myProvider.setItems(variants);
        this.setDirty(false);
    }

    @Override
    public void setActive(boolean active) {
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().setBackground(CompletionParamEditor.getBackground(active));
    }

    @Nullable
    public T getItemByText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "getItemByText"));
        }
        for (T item : this.myModel) {
            if (!text.equals(this.getText(item))) continue;
            return item;
        }
        for (T item : this.myModel) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)this.getText(item))) continue;
            return item;
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        String string = ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "getText"));
        }
        return string;
    }

    @Override
    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "setText"));
        }
        if (!text.equals(((ProgressFieldWithCompletion)this.getEditorComponent()).getField().getText())) {
            ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().setText(text);
        }
    }

    @Nullable
    protected abstract List<T> getVariants(@NotNull ProgressIndicator var1, @NotNull Map<Key, ?> var2) throws Exception;

    protected void updateModelAsync(boolean isAutoPopup) {
        this.myUpdater.update(isAutoPopup, Collections.emptyMap());
    }

    protected void updateModelForce() {
        this.myUpdater.update(false, Collections.singletonMap(FORCED_KEY, Boolean.TRUE));
    }

    protected void updateModelSync(boolean isAutoPopup) {
        this.myUpdater.updateSync(isAutoPopup, Collections.emptyMap());
    }

    protected void updateModelAtShow() {
        this.updateModelAsync(true);
    }

    @NotNull
    protected abstract String getText(@NotNull T var1);

    @Nullable
    protected String getTailText(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "getTailText"));
        }
        return null;
    }

    @Nullable
    protected String getTypeText(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "getTypeText"));
        }
        return null;
    }

    @Nullable
    protected Icon getIcon(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/CompletionParamEditor", "getIcon"));
        }
        return null;
    }

    public void setAsyncUpdateOnCompletion(boolean asyncUpdateOnCompletion) {
        this.myAsyncUpdateOnCompletion = asyncUpdateOnCompletion;
    }

    public void setForceRefresh(@Nullable String forceRefreshTitle) {
        this.myForceRefreshTitle = forceRefreshTitle;
    }

    public boolean canRefresh() {
        return this.myUpdater.myRunning == null || this.mySupersedeTasks;
    }

    private static class MyForceRefresh
    extends DumbAwareAction {
        public static final AnAction INSTANCE = new MyForceRefresh();

        public MyForceRefresh() {
            super("Refresh", "", AllIcons.Actions.Refresh);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            CompletionParamEditor editor = this.getParamEditor(e.getDataContext());
            if (editor == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            presentation.setVisible(true);
            presentation.setEnabled(editor.canRefresh());
            presentation.setText(editor.myForceRefreshTitle);
        }

        public void actionPerformed(AnActionEvent e) {
            CompletionParamEditor editor = this.getParamEditor(e.getDataContext());
            if (editor == null) {
                return;
            }
            editor.updateModelForce();
        }

        @Nullable
        CompletionParamEditor getParamEditor(@NotNull DataContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$MyForceRefresh", "getParamEditor"));
            }
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
            if (editor == null) {
                return null;
            }
            return (CompletionParamEditor)PARAM_EDITOR_KEY.get((UserDataHolder)editor);
        }
    }

    public static class ProgressFieldWithCompletion<T>
    extends JPanel
    implements Disposable,
    Runnable {
        private AsyncProcessIcon myBusyIcon = new AsyncProcessIcon("updating");
        private boolean myBusy;
        private final TextFieldWithAutoCompletion<T> myField;

        public ProgressFieldWithCompletion(Project project) {
            this.setLayout(new OverlayLayout(this));
            this.myField = new TextFieldWithAutoCompletion(project, TextFieldWithAutoCompletion.EMPTY_COMPLETION, true, null);
            this.myBusyIcon.setVisible(false);
            this.myBusyIcon.suspend();
            this.add((Component)this.myBusyIcon);
            this.add((Component)this.myField);
            Disposer.register((Disposable)this, (Disposable)this.myBusyIcon);
        }

        @NotNull
        public TextFieldWithAutoCompletion<T> getField() {
            TextFieldWithAutoCompletion<T> textFieldWithAutoCompletion = this.myField;
            if (textFieldWithAutoCompletion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$ProgressFieldWithCompletion", "getField"));
            }
            return textFieldWithAutoCompletion;
        }

        public void dispose() {
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.updateBusyLocation();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.updateBusyLocation();
        }

        public void setBusy(boolean busy) {
            if (this.myBusy == busy) {
                return;
            }
            this.myBusy = busy;
            UIUtil.invokeLaterIfNeeded((Runnable)this);
        }

        @Override
        public void run() {
            this.myBusyIcon.setVisible(this.myBusy);
            if (this.myBusy) {
                this.myBusyIcon.resume();
            } else {
                this.myBusyIcon.suspend();
            }
            this.revalidate();
        }

        public void updateBusyLocation() {
            Rectangle rec;
            if (this.myField.getEditor() != null) {
                JComponent component = this.myField.getEditor().getComponent();
                rec = SwingUtilities.convertRectangle(component, component.getVisibleRect(), this);
            } else {
                rec = this.myField.getVisibleRect();
            }
            Dimension iconSize = this.myBusyIcon.getPreferredSize();
            int displacement = Math.max((rec.height - iconSize.height) / 2, 0);
            Rectangle newBounds = new Rectangle(rec.x + rec.width - iconSize.width - displacement, rec.y + displacement, iconSize.width, iconSize.height);
            if (!newBounds.equals(this.myBusyIcon.getBounds())) {
                this.myBusyIcon.setBounds(newBounds);
                SwingUtilities.invokeLater(() -> this.repaint());
            }
        }
    }

    private class MyUpdater {
        private volatile ProgressIndicator myRunning;

        private MyUpdater() {
        }

        public void update(boolean isAutoPopup, @NotNull Map<Key, ?> options) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$MyUpdater", "update"));
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (options == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$MyUpdater", "lambda$update$0"));
                }
                if (CompletionParamEditor.this.mySupersedeTasks || this.myRunning == null) {
                    DataSourceUiUtil.runAsyncWithCorrectModality(new MyTask(isAutoPopup, options));
                }
            });
        }

        public void updateSync(boolean isAutoPopup, @NotNull Map<Key, ?> options) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$MyUpdater", "updateSync"));
            }
            if (CompletionParamEditor.this.mySupersedeTasks || this.myRunning == null) {
                DataSourceUiUtil.runSynchronously((Task)new MyTask(isAutoPopup, options));
            }
        }

        private class MyTask
        extends Task.Backgroundable {
            private final boolean myAutoPopup;
            private final Map<Key, ?> myOptions;
            private volatile ProgressIndicator myIndicator;

            public MyTask(@NotNull boolean isAutoPopup, Map<Key, ?> options) {
                if (options == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$MyUpdater$MyTask", "<init>"));
                }
                super(CompletionParamEditor.this.getInterchange().getProject(), CompletionParamEditor.this.myUpdateTitle, true);
                this.myAutoPopup = isAutoPopup;
                this.myOptions = options;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                block5: {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$MyUpdater$MyTask", "run"));
                    }
                    this.myIndicator = indicator;
                    this.start();
                    indicator.checkCanceled();
                    try {
                        List res = CompletionParamEditor.this.getVariants(indicator, this.myOptions);
                        if (res == null) {
                            return;
                        }
                        CompletionParamEditor.this.setCompletionVariants(res);
                        UIUtil.invokeLaterIfNeeded(() -> CompletionParamEditor.this.setVariants(res));
                    }
                    catch (ProcessCanceledException res) {
                    }
                    catch (Exception e) {
                        if (this.myAutoPopup && !CompletionParamEditor.this.myReportErrorOnAutoPopup) break block5;
                        CompletionParamEditor.this.getInterchange().showError(e, (Object)this);
                    }
                }
            }

            public void onCancel() {
                super.onCancel();
                this.finish();
            }

            public void onSuccess() {
                super.onSuccess();
                this.finish();
            }

            private synchronized void start() {
                ProgressIndicator old = MyUpdater.this.myRunning;
                MyUpdater.this.myRunning = this.myIndicator;
                if (old != null) {
                    old.cancel();
                }
                ((ProgressFieldWithCompletion)CompletionParamEditor.this.getEditorComponent()).setBusy(true);
            }

            private synchronized void finish() {
                if (MyUpdater.this.myRunning == this.myIndicator) {
                    MyUpdater.this.myRunning = null;
                    ((ProgressFieldWithCompletion)CompletionParamEditor.this.getEditorComponent()).setBusy(false);
                }
                this.myIndicator = null;
            }
        }
    }

    private class CompletionProvider
    extends TextFieldWithAutoCompletionListProvider<T> {
        protected CompletionProvider() {
            super(null);
        }

        @NotNull
        public Collection<T> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            CompletionParamEditor.this.onCompletion(parameters.isAutoPopup());
            Collection collection = super.getItems(prefix, cached, parameters);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$CompletionProvider", "getItems"));
            }
            return collection;
        }

        @Nullable
        protected Icon getIcon(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$CompletionProvider", "getIcon"));
            }
            return CompletionParamEditor.this.getIcon(item);
        }

        @NotNull
        protected String getLookupString(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$CompletionProvider", "getLookupString"));
            }
            String string = CompletionParamEditor.this.getText(item);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$CompletionProvider", "getLookupString"));
            }
            return string;
        }

        @Nullable
        protected String getTailText(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$CompletionProvider", "getTailText"));
            }
            return CompletionParamEditor.this.getTailText(item);
        }

        @Nullable
        protected String getTypeText(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$CompletionProvider", "getTypeText"));
            }
            return CompletionParamEditor.this.getTypeText(item);
        }

        public int compare(T item1, T item2) {
            return StringUtil.naturalCompare((String)this.getLookupString(item1), (String)this.getLookupString(item2));
        }
    }
}

